<!-- Compresser l'image pendant le transfert version 2.4 du 16.12.2025 -->
<?php
/* Compress image during transfer pour Deltacms
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 * @copyright 2025 © Lionel Croquefer
 */
$group = $this->getUser('group') === false ? 0 : $this->getUser('group');
$avifenabled = version_compare(PHP_VERSION, '8.2.0', '>=') && function_exists('imagecreatefromavif');
$avif = $avifenabled ? 'avif, ' : '';
$controluser = ($this->getUser('group') >= self::GROUP_ADMIN && $this->getUser('password') === $this->getInput('DELTA_USER_PASSWORD')) ?? false;
	// Langue de l'interface en, es ou fr
	if ($controluser == true) {
		$langue = $this->getData(['config', 'i18n', 'langAdmin']);
	}
	else {
		if (isset($_SESSION['langFrontEnd']) && isset($_SESSION['translationType']) && $_SESSION['translationType'] === 'site') {
			$langue = $_SESSION['langFrontEnd'];
		}
		else {
			$langue = $this->getData(['config', 'i18n', 'langBase']);
		}
	}
	if (file_exists('plugin/CompressImage/lang/'. $langue .'/lex_CompressImage.php')) {
		include('plugin/CompressImage/lang/'. $langue .'/lex_CompressImage.php');
	}
	else {
		include('plugin/CompressImage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) .'/lex_CompressImage.php');
	}
	// Largeur memorisée
	if (isset($_POST['width'])) {
		$memorised_width = $_POST['width'];
	}
	elseif (isset($_SESSION['width'])) {
		$memorised_width = $_SESSION['width'];
	}
	else { $memorised_width = ''; }
	$_SESSION['width'] = $memorised_width;

	// hauteur memorisée
	if (isset($_POST['height'])) {
		$memorised_height = $_POST['height'];
	}
	elseif (isset($_SESSION['height'])) {
		$memorised_height = $_SESSION['height'];
	}
	else { $memorised_height = ''; }
	$_SESSION['height'] = $memorised_height;

	// Qualité memorisée
	if (isset($_POST['quality'])) {
		$memorised_quality = $_POST['quality'];
	}
	elseif (isset($_SESSION['quality'])) {
		$memorised_quality = $_SESSION['quality'];
	}
	else { $memorised_quality = ''; }
	$_SESSION['quality'] = $memorised_quality;

	// Définition et mémorisation du dossier recevant les images
	if (isset($_POST['folder'])) {
		$upload_directory = $_POST['folder'];
	}
	elseif (isset($_SESSION['folder'])) {
		$upload_directory = $_SESSION['folder'];
	}
	else {
	$upload_directory = self::FILE_DIR.'source/'.$files_directory.'/';
		if (is_dir($upload_directory) === false) {
		mkdir($upload_directory,0755);
		clearstatcache();
		}
	}
	$_SESSION['folder'] = $upload_directory;
	if ($group >= 1) {
	?>
	<div class="block" id="cdt">
		<div class="blockTitle"><?=$text['cdt']['title'][0]?>
		<span class="helpButton" data-tippy-content="<?=$text['cdt']['help'][0]?>">
		<a href="plugin/CompressImage/CompressImage_doc.pdf" rel="data-lity"><span class="delta-ico-help delta-ico-margin-left"></span></a>
		</span>
		</div>
	<div class="row">
	<div class="col6">
	<form method="post" enctype="multipart/form-data" id="transfer">
	<table id="upload">
	<tr>
	<td><label><?=$text['cdt']['upload'][0]?></label><input type="file" name="uploadImg" accept="image/*"></td>
	</tr>
	<tr>
	<td><label for="width"><?=$text['cdt']['upload'][1]?></label><input type="text" name="width" id="width" maxlength="5" class="numonly"></td>
	</tr>
	<tr>
	<td><label for="height"><?=$text['cdt']['upload'][2]?></label><input type="text" name="height" id="height" maxlength="5" class="numonly"></td>
	</tr>
	<tr>
	<td><label for="quality"><?=$text['cdt']['upload'][3]?></label><input type="text" name="quality" id="quality" maxlength="3" class="numonly"></td>
	</tr>
	<tr>
	<td><label><?=$text['cdt']['upload'][4]?></label><select name="folder" id="selectfolder">
	<?php
	$filedir = self::FILE_DIR.'source';
	// Recherche récursive de dossiers et de sous dossiers
	function scanDirectory($dir) {
		$exclus = ['agenda','backup','data','fonts','icones','membersDirectory','theme','tn','w'];
		$dirContent = [];
		$iterator = new DirectoryIterator($dir);
		foreach($iterator as $fileInfos) {
			if($fileInfos->isDot() === false AND $fileInfos->isDir()) {
				if(in_array($fileInfos, $exclus)) continue;
  				$dirContent[] = $dir.'/'.$fileInfos->getBasename();
				$dirContent = array_merge($dirContent, scanDirectory($dir.'/'.$fileInfos->getBasename()));
			}
		}
	return $dirContent;
	}
	// Recherche les dossiers recevant les images
	$dirsearch = scanDirectory($filedir);
	natcasesort($dirsearch);
	foreach ($dirsearch as $dirfound) {
		echo '<option value="'.$dirfound.'/'.'">'.str_replace($filedir.'/','',$dirfound).'</option>';
	}
	?>
	</select>
	</td>
	</tr>
	<tr>
	<td><button type="submit" name="transfer" value="send"><?=$text['cdt']['upload'][5]?></button></td>
	</tr>
	</table>
	</form>
<script>
	$('#width').val('<?=$memorised_width?>');
	$('#height').val('<?=$memorised_height?>');
	$('#quality').val('<?=$memorised_quality?>');
	$('#selectfolder').val('<?=$upload_directory?>');
	$(function () {
		$("input[class='numonly']").on('input', function (e) {
			$(this).val($(this).val().replace(/[^0-9]/g, ''));
		});
	});
</script>
	</div>
	<!-- colonne de droite -->
	<div class="col6">
	<ul id="transferinfos">
	<li><?=$text['cdt']['info'][0]?></li>
	<li><?=$text['cdt']['info'][1]?></li>
	<li><?=$text['cdt']['info'][2]?></li>
	<li><?=$text['cdt']['info'][3]?>
		<ul>
		<li><?=$text['cdt']['info'][4]?></li>
		<li><?=$text['cdt']['info'][5]?></li>
		</ul>
	</li>
	</ul>
	<?php }
	if (isset($_POST['unlinkOriginal'])) {
	unlink($_POST['unlinkOriginal']);
	}
	$success = false;
	if (isset($_POST['transfer']) && !empty($_POST['transfer'])) {
	if (isset($_FILES['uploadImg']['name']) && $_FILES['uploadImg']['name'] != '') {
	if ($_FILES['uploadImg']['error'] > 0) {
	echo '<p class="cdt-info">'.$text['cdt']['alert'][0].'</p>';
	} else {
	if ($_FILES['uploadImg']['size'] / 1024 <= 20480) {
	if ($_FILES['uploadImg']['type'] == 'image/jpeg' ||
	$_FILES['uploadImg']['type'] == 'image/png' ||
	$_FILES['uploadImg']['type'] == 'image/webp' ||
	($_FILES['uploadImg']['type'] == 'image/avif' && $avifenabled) ) {

	$source_file = $_FILES['uploadImg']['tmp_name'];
	$target_file = $upload_directory . $_FILES['uploadImg']['name'];
	$quality = $memorised_quality;
	$image_info = getimagesize($source_file);
	// Qualité par défaut
	if ( (in_array($image_info[2],[2,18,19]) and ($quality == '' || $quality < 0 || $quality > 100)) or ($image_info[2] == 3 and ($quality == '' || $quality < 0 || $quality > 9)) ) { $quality = -1; }
	// Obtention des infos largeur et hauteur nécessaires au calcul
	$width = $image_info[0];
	$height = $image_info[1];
	// Redimensionnement avec ratio, proportions de l'image respectées
	$newwidth = !empty($memorised_width) ? (int) $memorised_width : 0;
	$newheight = !empty($memorised_height) ? (int) $memorised_height : 0;
	// Si les nouvelles dimensions sont supérieures aux originales
	if ($newwidth > $width || $newheight > $height)
	{
	echo '<p class="cdt-info">'.$text['cdt']['alert'][1].' : '.$width.' x '.$height.'</p>';
	}
	// Si l'une des dimensions n'est pas spécifiée, la manquante est définie de façon à ne pas être une contrainte
	if (!$newwidth && $newheight)
	{
	$newwidth = 999999;
	}
	elseif ($newwidth && !$newheight)
	{
	$newheight = 999999;
	}
	// Configuration des ratios nécessaires au redimensionnement
	$xRatio = $newwidth / $width;
	$yRatio = $newheight / $height;
	// Redimensionnement de l'image en fonction de la largeur
	if ($xRatio * $height < $newheight)
	{
	$tnHeight = ceil($xRatio * $height);
	$tnWidth = $newwidth;
	}
	// Redimensionnement de l'image en fonction de la hauteur
	else
	{
	$tnWidth = ceil($yRatio * $width);
	$tnHeight = $newheight;
	}
	// Voila !
	$success = compress_image($source_file, $target_file, $tnWidth, $tnHeight, $quality);
	// copie des métadonnées dans les images jpeg
	if ($image_info[2] == 2) {
	transferIptcExif2File($source_file,$target_file);
	// ajout d'un champ IPTC
	getimagesize ($target_file,$info);
	if (isset($info["APP13"])) {
		$iptc = iptcparse ($info["APP13"]);
		}
		$iptc = ['2#120' => 'Compressed copy from image '.$_FILES['uploadImg']['name'], '2#122' => 'CompressImage plugin - Deltacms (deltacms.fr)'];
		$iptcdata = NULL;
	foreach($iptc as $tag => $string) {
		$tag = substr($tag, 2);
		$iptcdata .= transformer_iptc($tag, $string);
		}
		$donnees = iptcembed($iptcdata, $target_file);
		$fichier = fopen($target_file, "wb");
		fwrite($fichier, $donnees);
		fclose($fichier);
	}
	if ($success) {
	// L'image originale est envoyée sur le serveur afin d'être comparée à l'image compressée
	copy($source_file, $upload_directory .'original_'. $_FILES['uploadImg']['name']);
	}
	}
	else { echo '<p class="cdt-info">'.$text['cdt']['alert'][2].'</p>'; }
	}
	else { echo '<p class="cdt-info">'.$text['cdt']['alert'][3].'</p>'; }
	}
	}
	else { echo '<p class="cdt-info">'.$text['cdt']['alert'][4].'</p>'; }
	}
// fonctions
function transferIptcExif2File($srcfile, $destfile) {
	if (file_exists($srcfile) && file_exists($destfile)) {
	getimagesize($srcfile, $imageinfo);
	// Prepare EXIF data bytes from source file
	$exifdata = (is_array($imageinfo) && key_exists("APP1", $imageinfo)) ? $imageinfo['APP1'] : null;
	if ($exifdata) {
		$exiflength = strlen($exifdata) + 2;
		if ($exiflength > 0xFFFF) return false;
		// Construct EXIF segment
		$exifdata = chr(0xFF) . chr(0xE1) . chr(($exiflength >> 8) & 0xFF) . chr($exiflength & 0xFF) . $exifdata;
	}
	// Prepare IPTC data bytes from source file
	$iptcdata = (is_array($imageinfo) && key_exists("APP13", $imageinfo)) ? $imageinfo['APP13'] : null;
	if ($iptcdata) {
		$iptclength = strlen($iptcdata) + 2;
		if ($iptclength > 0xFFFF) return false;
		// Construct IPTC segment
		$iptcdata = chr(0xFF) . chr(0xED) . chr(($iptclength >> 8) & 0xFF) . chr($iptclength & 0xFF) . $iptcdata;
	}
	$destfilecontent = file_get_contents($destfile);
	if (!$destfilecontent) return false;
	if (strlen($destfilecontent) > 0) {
		$destfilecontent = substr($destfilecontent, 2);
		$portiontoadd = chr(0xFF) . chr(0xD8); // Variable accumulates new & original IPTC application segments
		$exifadded = !$exifdata;
		$iptcadded = !$iptcdata;

	$numeric = (int)str_replace(',', '', $destfilecontent);
	while ((substr($numeric, 0, 2) & 0xFFF0) === 0xFFE0) {
		$segmentlen = (substr($destfilecontent, 2, 2) & 0xFFFF);
		$iptcsegmentnumber = (substr($destfilecontent, 1, 1) & 0x0F); // Last 4 bits of second byte is IPTC segment #
		if ($segmentlen <= 2) return false;
		$thisexistingsegment = substr($destfilecontent, 0, $segmentlen + 2);
		if ((1 <= $iptcsegmentnumber) && (!$exifadded)) {
			$portiontoadd .= $exifdata;
			$exifadded = true;
			if (1 === $iptcsegmentnumber) $thisexistingsegment = '';
		}
		if ((13 <= $iptcsegmentnumber) && (!$iptcadded)) {
			$portiontoadd .= $iptcdata;
			$iptcadded = true;
			if (13 === $iptcsegmentnumber) $thisexistingsegment = '';
		}
		$portiontoadd .= $thisexistingsegment;
		$destfilecontent = substr($destfilecontent, $segmentlen + 2);
		}
		if (!$exifadded) $portiontoadd .= $exifdata;  //  Add EXIF data if not added already
		if (!$iptcadded) $portiontoadd .= $iptcdata;  //  Add IPTC data if not added already
		$outputfile = fopen($destfile, 'w');
		if ($outputfile) return fwrite($outputfile, $portiontoadd . $destfilecontent); else return false;
	}
	else { return false; }
	}
	else { return false; }
} // /transferIptcExif2File
function transformer_iptc($data, $value) {
	$length = strlen($value);
	$retval = chr(0x1C).chr(2).chr($data);
	if($length < 0x8000)
	  $retval .= chr($length >> 8).chr($length& 0xFF);
	else{
	  $retval .= chr(0x80).chr(0x04).
				 chr(($length >> 24)& 0xFF).
				 chr(($length >> 16)& 0xFF).
				 chr(($length >> 8)& 0xFF).
				 chr($length& 0xFF);
	}
	return $retval.$value;
}// /transformer_iptc
function compress_image($source_file, $target_file, $nwidth, $nheight, $quality) {
	$image_info = getimagesize($source_file);
	if (!($nwidth > 0)) $nwidth = $image_info[0];
	if (!($nheight > 0)) $nheight = $image_info[1];
	$compressimg = imagecreatetruecolor($nwidth, $nheight);
	$transparency = [3,18,19];
	if (in_array($image_info[2],$transparency)) {
		imagecolortransparent($compressimg, imagecolorallocatealpha($compressimg, 0, 0, 0, 127));
		imagealphablending($compressimg, false);
		imagesavealpha($compressimg, true);
	}

	if (!empty($image_info)) {
	switch($image_info['mime']) {

	case 'image/jpeg' :
	$image = imagecreatefromjpeg($source_file);
	imagecopyresampled($compressimg, $image, 0, 0, 0, 0, $nwidth, $nheight, $image_info[0], $image_info[1]);
	return imagejpeg($compressimg, $target_file, $quality);
	break;

	case 'image/png' :
	$image = imagecreatefrompng($source_file);
	imagecopyresampled($compressimg, $image, 0, 0, 0, 0, $nwidth, $nheight, $image_info[0], $image_info[1]);
	return imagepng($compressimg, $target_file, $quality);
	break;

	case 'image/webp' :
	$webpContents = file_get_contents($source_file);
	$anim = ( strpos($webpContents, 'ANIM') !== false || strpos($webpContents, 'ANMF') !== false );
	if ($anim === false) {
	$image = imagecreatefromwebp($source_file);
	imagecopyresampled($compressimg, $image, 0, 0, 0, 0, $nwidth, $nheight, $image_info[0], $image_info[1]);
	return imagewebp($compressimg, $target_file, $quality);
	}
	else { echo '<p class="cdt-info">'.WEBPA.'</p>'; }
	break;

	case 'image/avif' :
	$image = imagecreatefromavif($source_file);
	imagecopyresampled($compressimg, $image, 0, 0, 0, 0, $nwidth, $nheight, $image_info[0], $image_info[1]);
	return imageavif($compressimg, $target_file, $quality);
	break;
		}
	}
} // /compress image
	if ($group >= 1) {
	?>
	<!-- Comparaison des images originale et compressée -->
	<?php if ($success) { ?>
	<table id="preview">
	<tr>
	<td class="preview">
	<a href="<?=$upload_directory .'original_'. $_FILES['uploadImg']['name']?>" rel="gallery" title="<?=$text['cdt']['preview'][0]?>"><img src="<?=$upload_directory .'original_'. $_FILES['uploadImg']['name']?>" alt="<?=pathinfo('original_' . $_FILES['uploadImg']['name'], PATHINFO_FILENAME)?>"></a>
	<br><span><?=$text['cdt']['preview'][2]?> → <?php echo number_format(filesize($upload_directory .'original_'. $_FILES['uploadImg']['name'])/1024, 2, '.', ''). ' Kio';
	$imageToDelete = $upload_directory .'original_'. $_FILES['uploadImg']['name']; ?></span>
	<br><span><?=$width.' x '.$height?> px</span>
	</td>
	<td class="preview">
	<?php
	if ((empty($memorised_quality) || $quality == -1) && $memorised_quality != 0) { $compress = $text['cdt']['preview'][1].' → '; }
	else { $compress = $text['cdt']['info'][3].' '.$quality.' → '; }
	if ($tnWidth * $tnHeight == 0) { $targetSize = $width.' x '.$height; }
	else { $targetSize = $tnWidth.' x '.$tnHeight; }
	?>
	<a href="<?=$upload_directory . $_FILES['uploadImg']['name']?>" rel="gallery" title="<?=$text['cdt']['preview'][0]?>"><img src="<?=$upload_directory . $_FILES['uploadImg']['name']?>" alt="<?=pathinfo($_FILES['uploadImg']['name'], PATHINFO_FILENAME)?>"></a>
	<br><span><?=$compress . number_format(filesize($upload_directory . $_FILES['uploadImg']['name'])/1024, 2, '.', ''). ' Kio'?></span>
	<br><span><?=$targetSize?> px</span>
	</td>
	</tr>
	<tr>
	<td colspan="2">
	<form id="delete" method="post" name="formdel">
	<input type="hidden" name="unlinkOriginal" value="<?=$imageToDelete?>">
	<button type="submit" id="delbtn" data-tippy-content="... <?=$text['cdt']['delete'][1]?>."><?=$text['cdt']['delete'][0]?></button>
	</form>
	</td>
	</tr>
	</table>
	<?php } ?>
	</div>
	</div>
	</div>
	<?php
	if (isset($_POST['showall'])) {
		echo '<!-- Affichage des images du dossier courant -->
		<div id="showall">';
		$files = glob($_POST['showall'].'*', GLOB_BRACE);
		foreach($files as $file) {
		  if(is_file($file) && substr(mime_content_type($file), 0, 5) == 'image') {
			$infofile = getimagesize($file);
			 if(in_array($infofile[2],[2,3,18,19]))
			echo '<a href ="'.$file.'" rel="gallery"><img src="'.$file.'" alt="'.basename($file).'"></a>';
		  }
		}
		echo '</div>';
	}
	elseif (isset($_POST['deletall'])) {
		$files = glob($_POST['deletall'].'{,.}*', GLOB_BRACE);
		foreach($files as $file) {
		  if(is_file($file)) {
			unlink($file);
		  }
		}
	}
	?>
	<!-- Affiche ou supprime les fichiers du dossier courant -->
	<div id="undercdt">
	<form method="post" id="showallfiles" >
	<input type="hidden" name="showall" value="<?=$upload_directory?>">
	<button class="button" type="submit" data-tippy-content="<?=$text['undercdt'][0]?>"><?=$text['undercdt'][1]?></button>
	</form>
	<button class="button" type="button" data-tippy-content="<?=$text['undercdt'][2]?>" onClick="document.location.href = '<?=helper::baseUrl(true).$this->getUrl(0)?>'"><?=$text['undercdt'][3]?></button>
	<form method="post" id="deletallfiles">
	<input type="hidden" name="deletall" value="<?=$upload_directory?>">
	<button class="button" type="submit" data-tippy-content="<?=$text['undercdt'][4]?>" onClick="return confirm('<?=$text['undercdt'][6]?>')"><?=$text['undercdt'][5]?></button>
	</form>
	</div>
	<?php }
	else echo $text['warning'][0];
	?>
