<?php
/* Export PDF avec html2pdf adapté pour Deltacms
"html2pdf.js" by Erik Koopmans, licensed under MIT
"html2canvas" by Niklas von Hertzen, licensed under MIT
"jsPDF" by James Hall and contributors, licensed under MIT
"ES6-Promise" by Stefan Penner and contributors, licensed under MIT
*/
?> 
<script src="plugin/html2pdf/vendor/html2pdf/es6-promise.auto.min.js"></script>
<script src="plugin/html2pdf/vendor/html2pdf/jspdf.umd.min.js"></script>
<script src="plugin/html2pdf/vendor/html2pdf/html2canvas.min.js"></script>
<script src="plugin/html2pdf/vendor/html2pdf/html2pdf.min.js"></script>
<script>
document.getElementById('exportPdf').addEventListener('click', async function () {
    const section = document.querySelector('section');
	const images = section.querySelectorAll('img');
	// Suppression du bouton export pdf pour l'export
	const buttonPdf = section.querySelector('button#exportPdf');
	buttonPdf.classList.add("displayNone");
    // Détection couleur de fond réelle
    function getEffectiveBackgroundColor(el) {
        let color = window.getComputedStyle(el).backgroundColor;
        while ((color === 'rgba(0, 0, 0, 0)' || color === 'transparent') && el.parentElement) {
            el = el.parentElement;
            color = window.getComputedStyle(el).backgroundColor;
        }
        return color;
    }
    section.style.backgroundColor = getEffectiveBackgroundColor(section);
	// Option multipages: 'multipages' présente dans la liste des class du button exportPdf
	// l'option n'est pas valide en petit écran ou sur un terminal mobile
	const exportPdf = section.querySelector('#exportPdf');
    if (
        exportPdf.classList.contains('multipages') && window.matchMedia("(min-width: 800px)").matches &&                
        !/Mobi|Android|iPhone|iPad|iPod|BlackBerry|Windows Phone/i.test(navigator.userAgent)
    )  {
		const marginPdf = 5;
		images.forEach(img => {
			img.style.display = 'block';
			img.style.breakInside = 'avoid';
			img.style.pageBreakInside = 'avoid';
			// Images de hauteur trop importantes réduites à l'export
			let imgMaxMm = 210 - 2*marginPdf - 10;// -10 car marge haute ajoutée par jspdf ou html2canvas
			let imgMaxPx = Math.trunc(imgMaxMm * 96 / 25.4);
			if (img.height > imgMaxPx) {
				img.style.maxHeight = imgMaxMm + 'mm';
				img.style.height = 'auto';
				img.style.width = 'auto';
			}
		});
		// Ajout pour éviter coupures de paragraphes
		section.querySelectorAll('p').forEach(p => {
			p.style.display = 'block';
			p.style.breakInside = 'avoid';
			p.style.pageBreakInside = 'avoid';
			//console.log(p.height);
		});
		// Options PDF
		const opt = {
			margin: marginPdf,
			filename: 'export.pdf',
			image: { type: 'jpeg', quality: 0.65 },
			html2canvas:{ 
				scale: 2, 
				useCORS: true, 
				letterRendering: true, 
				backgroundColor: section.style.backgroundColor
			},
			jsPDF: { unit: 'mm', format: 'a4', orientation: 'landscape' },
			pagebreak: { mode: ['css','avoid-all','legacy'] }
		};
		// Génération du PDF
		await html2pdf().from(section).set(opt).save();
	} else { 
		// Options PDF avec taille personnalisée (une seule page)
		const opt = {
			margin: [0, 0, 0, 0],
			filename: 'export.pdf',
			image: { type: 'jpeg', quality: 0.65 },
			html2canvas:{ 
				scale: 2, 
				useCORS: true, 
				letterRendering: true, 
				backgroundColor: section.style.backgroundColor
			},
			jsPDF: { unit: 'px', format: [section.offsetWidth, section.offsetHeight] }
		};	
		// Génération du PDF
		const pdf = await html2pdf().from(section).set(opt).toPdf().get('pdf');
		// Supprimer la dernière page car si elle existe elle est vide
		if (pdf.internal.getNumberOfPages() > 1) {
			pdf.deletePage(2);
		}
		pdf.save('export.pdf');
	} 
	// Rechargement de la page
    location.reload();
});
</script>







