<?php
// Lexique
$param = "geophoto_view";
include('./module/geophoto/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_geophoto.php');

	if( isset( $_SESSION['langFrontEnd']) && isset( $_SESSION['translationType']) && $_SESSION['translationType'] === 'site' ){
		$langue_choisie =  $_SESSION['langFrontEnd'];
	} else {
		$langue_choisie = $this->getData(['config', 'i18n', 'langBase']);
	}

	$Infos_Desc = $this->getData(['module', $this->getUrl(0), $this->getUrl(2), 'config', 'directory']).'/infos-'.$langue_choisie.'.htm';
		if(isset($_POST['descriptif'])) {
			file_put_contents($Infos_Desc, trim($_POST['descriptif']), LOCK_EX);
		}
// Adaptation de la langue dans tinymce pour la rédaction d'un message en fonction de la langue de la page, originale ou en traduction rédigée
$lang = $this->getData(['config', 'i18n', 'langBase']);
if ( !empty($_COOKIE["DELTA_I18N_SITE"])) {
	if( $this->getInput('DELTA_I18N_SITE') !== 'base' ) $lang = $this->getInput('DELTA_I18N_SITE');
}
$lang_page = $lang;
switch ($lang) {
	case 'en' :
		$lang_page = 'en_GB';
		break;
	case 'pt' :
		$lang_page = 'pt_PT';
		break;
	case 'sv' :
		$lang_page = 'sv_SE';
		break;
	case 'fr' :
		$lang_page = 'fr_FR';
		break;
}
// Si la langue n'est pas supportée par Tinymce la langue d'administration est utilisée
if( ! file_exists( 'core/vendor/tinymce/langs/'.$lang_page.'.js' )){
	$lang_page = $text['core']['showComment'][7];
}
 ?>
	<script> var lang_admin = "<?=$lang_page?>"; </script>
    <script src="core/vendor/tinymce/tinymce.min.js" referrerpolicy="origin"></script>
 <?php
echo template::formOpen('galleryEditForm'); ?>
	<div class="row">
		<div class="col2">
			<?php echo template::button('galleryEditBack', [
				'class' => 'buttonGrey',
				'href' => helper::baseUrl() . $this->getUrl(0) . '/config',
				'ico' => 'left',
				'value' => $text['geophoto_view']['edit'][0]
			]); ?>
		</div>
		<div class="col2 offset8">
			<?php echo template::submit('galleryEditSubmit',[
				'value' => $text['geophoto_view']['edit'][1]
			]); ?>
		</div>
	</div>
	<div class="row">
		<div class="col12">
			<div class="block">
				<div class="blockTitle"><?php echo $text['geophoto_view']['edit'][2]; ?></div>
				<div class="row">
					<div class="col5">
						<?php echo template::text('galleryEditName', [
							'label' => $text['geophoto_view']['edit'][3],
							'value' => $this->getData(['module', $this->getUrl(0), $this->getUrl(2), 'config', 'name']),
							'readonly' => $this->getUser('group') >= self::GROUP_MODERATOR ? false : true
						]); ?>
					</div>
					<div class="col4 <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo 'displayNone'; ?>">
						<?php echo template::hidden('galleryEditDirectoryOld', [
							'value' => $this->getData(['module', $this->getUrl(0), $this->getUrl(2), 'config', 'directory']),
							'noDirty' => true // Désactivé à cause des modifications en ajax
						]); ?>
						<?php echo template::select('galleryEditDirectory', [], [
							'label' => $text['geophoto_view']['edit'][4],
							'noDirty' => true // Désactivé à cause des modifications en ajax
						]); ?>
					</div>
					<div class="col3">
						<?php echo template::select('galleryEditSort', $sort, [
							'selected' => $this->getData(['module', $this->getUrl(0), $this->getUrl(2), 'config', 'sort']),
							'label' => $text['geophoto_view']['edit'][5],
							'help' => $text['geophoto_view']['edit'][6]
                            ]); ?>
					</div>
				</div>
				<div class="row">
					<div class="col12">
						<?php if($module::$pictures): ?>
							<?php echo template::table([1, 4, 1, 5, 1], $module::$pictures, ['',$text['geophoto_view']['edit'][7], $text['geophoto_view']['edit'][8],$text['geophoto_view']['edit'][9],''],['id' => 'galleryTable'], $module::$picturesId ); ?>
							<?php echo template::hidden('galleryEditFormResponse'); ?>
							<?php echo template::hidden('galleryEditFormGalleryName',['value' => $this->getUrl(2)]); ?>
						<?php else: ?>
							<?php echo template::speech($text['geophoto_view']['edit'][10]); ?>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php echo template::formClose(); ?>
<div class="row">
	<div class="col12">
		<div class="block">
			<div class="blockTitle"><?=$text['geophoto_view']['edit'][13]?></div>
				<form method="post" id="editdesc">
					<textarea name="descriptif" id="GeoGalDesc">
					<?php
					if(isset($_POST['descriptif'])) {
					echo trim($_POST['descriptif']);
					}
					elseif (file_exists($Infos_Desc)) {
					readFile($Infos_Desc);
					}
					?>
					</textarea>
					<div class="col2 offset5">
						<button class="button buttonGrey"><?=$text['geophoto_view']['edit'][12]?></button>
					</div>
				</form>
		</div>
	</div>
</div>
<div class="row">
	<div class="col12">
		<div class="moduleVersion">
			<?php echo $text['geophoto_view']['edit'][11]; echo $module::VERSION; ?>
		</div>
	</div>
</div>
