<?php

/**
 * This file is part of DeltaCMS.
 * For full copyright and license information, please see the LICENSE
 * file that was distributed with this source code.
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2021, Sylvain Lelièvre
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 *
 * Delta was created from version 11.2.00.24 of ZwiiCMS
 * @author Rémi Jean <remi.jean@outlook.com>
 * @copyright Copyright (C) 2008-2018, Rémi Jean
 * @author Frédéric Tempez <frederic.tempez@outlook.com>
 * @copyright Copyright (C) 2018-2021, Frédéric Tempez
 */
 
 

class modele extends common {

	public static $actions = [
		'index' => self::GROUP_VISITOR,
		'config' => self::GROUP_MODERATOR
	];
	
	// N° de version
	const VERSION ='2.1';
	// Nom réél ou alias apparaissant lors du choix de module
	const REALNAME = 'Modèle';
	// Suppression autorisée depuis la gestion des modules
	const DELETE = true;
	// Mise à jour autorisée pour toutes les versions >= 0.0
	const UPDATE = '0.0';
	// ici DATADIRECTORY = '' car ni de données externes à module.json, ni de fichier theme.css pour les pages utilisant ce module 
	// Sinon il faut noter :  const DATADIRECTORY = self::DATA_DIR.'nom_du_module/'; 
	// placer les données qui sont communes à toutes les pages utilisant ce module dans  self::DATADIRECTORY.'module/'
	// placer les données de thèmes (comme theme.css) dans self::DATADIRECTORY.'nom_page/'
	// les autres données de page spécifiques à la page, traduite ou pas, sont à placer dans 'data_module/nom_page.json'
	// en utilisant la fonction $this->setData(['data_module', $this->getUrl(0), 'data', $vos_datas]). Lecture par $this->getData(['data_module', $this->getUrl(0), 'data'])
	const DATADIRECTORY = '';
	
	

	/**
	* La fonction config() est réservée aux modérateurs ou administrateurs, elle permet de paramétrer le module,
	* elle est utilisée pour ALLER en configuration et pour traiter les informations au RETOUR
	* le script de configuration est dans .../view/config/config.php, il ne doit contenir que la partie affichage, la parie VISIBLE
	* toute la partie traitement doit être ici ! c'est le principe de l'architecture MVC : Modèle Vue Contrôleur
	*/
	public function config() {
		// Autorisation : cette fonction sensible ne s'exécute que si le groupe de l'utilisateur y est autorisé
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < modele::$actions['config'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique, il contient les textes de la fonction dans le tableau $text['modele']['config']
			include('./module/modele/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_modele.php');
			
			// RETOUR de configuration par Enregistrer
			if($this->isPost()) {
			
			
				// Enregistrement dans module.json
				$this->setData(['module', $this->getUrl(0), 'config',[
						'message' => $this->getInput('modeleConfigParam1', helper::FILTER_STRING_SHORT, true),
					]
				]);
						
				// Message et redirection (ici sur la page de configuration) après enregistrement de la configuration
				$this->addOutput([
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'notification' => $text['modele']['config'][0],
					'state' => true
				]);
			
			}
		
			// ALLER à la configuration du module
			$this->addOutput([
				'title' => $text['modele']['config'][1],
				'view' => 'config'
			]);
		}
	}
	
	/**
	* La fonction index() est la fonction principale dont la partie VIEW sera visible par tous les visiteurs
	*/
	public function index() {
		// Lexique, il contient les textes de la fonction dans le tableau $text['modele']['index']
		include('./module/modele/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_modele.php');

		// Ici la partie traitement, la partie VISIBLE sera dans le script .../view/index/index.php
		
		// Module non configuré ?
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'message' ])){
			// ALLER à la configuration du module
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0).'/config',
				'notification' => $text['modele']['index'][0],
				'state' => true
			]);
		}
		
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index'
		]);
		
	}	

}
