<!-- Ouverture du formulaire de configuration -->
<?php
// Lexique, il contient les textes de la page et les variables tableau pour les select, ici $configParam1
include('./module/modele/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_modele.php');

echo template::formOpen('modeleConfigForm'); ?>

	<!-- Boutons Retour et submit (Enregistrer) -->
	<div class="row">
		<div class="col2">
			<?php echo template::button('modeleConfigBack', [
				'class' => 'buttonGrey',
				'href' => helper::baseUrl() . 'page/edit/' . $this->getUrl(0),
				'ico' => 'left',
				'value' => $text['modele_view']['config'][0]
			]); ?>
		</div>
		<div class="col2 offset8">
			<?php echo template::submit('modeleConfigSubmit', [
				'value' => $text['modele_view']['config'][1]
			]); ?>
		</div>
	</div>
	
	<!-- Dans un block un select pour choisir la phrase à afficher, la class template permet d'utiliser select, text, button, textarea, checkbox, ... -->
	<div class="block">
		<div class="blockTitle"><?php echo $text['modele_view']['config'][2]; ?></div>
		<div class="row">
			<div class="col6">
				<?php echo template::select('modeleConfigParam1', $configParam1,[
					'help' => $text['modele_view']['config'][3],
					'label' => $text['modele_view']['config'][4],
					'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'message'])
				]); ?>	
			</div>
		</div>
	</div>

<!-- Fermeture du formulaire et affichage du n° de version -->
<?php echo template::formClose(); ?>

<div class="moduleVersion">
	<?php echo $text['modele_view']['config'][5].$module::VERSION; ?>
</div>