<?php

/**
 * This file is part of DeltaCMS.
 * For full copyright and license information, please see the LICENSE
 * file that was distributed with this source code.
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2021, Sylvain Lelièvre
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 *
 * Delta was created from version 11.2.00.24 of ZwiiCMS
 * @author Rémi Jean <remi.jean@outlook.com>
 * @copyright Copyright (C) 2008-2018, Rémi Jean
 * @author Frédéric Tempez <frederic.tempez@outlook.com>
 * @copyright Copyright (C) 2018-2021, Frédéric Tempez
 */
 
class petition extends common {

	const VERSION = '1.1';
	const REALNAME = 'Simple pétition';
	const DELETE = true;
	const UPDATE = '0.0';
	//const DATADIRECTORY = ''; // Contenu localisé inclus par défaut (page.json et module.json)
	
	

	public static $actions = [
		'config' => self::GROUP_EDITOR,
		'update' => self::GROUP_EDITOR,
		'data' => self::GROUP_MODERATOR,
		'delete' => self::GROUP_MODERATOR,
		'deleteall' => self::GROUP_MODERATOR,
		'index' => self::GROUP_VISITOR,
		'export2csv' => self::GROUP_MODERATOR,
		'surveyValidation' => self::GROUP_VISITOR,
		'texts' => self::GROUP_MODERATOR,
	];

	public static $data = [];

	public static $pages = [];

	public static $pagination;
	
	public static $messageValidation;

	// Objets
	const TYPE_MAIL = 'mail';
	const TYPE_SELECT = 'select';
	const TYPE_SELECT_MUL = 'selectMultiple';
	const TYPE_TEXT = 'text';
	const TYPE_TEXTAREA = 'textarea';
	const TYPE_CHECKBOX = 'checkbox';
	const TYPE_LABEL = 'label';
	const ITEMSPAGE = 10;

	public static $listUsers = [
	];
	
	public static $logoWidth = [
		'40' => '40%',
		'60' => '60%',
		'80' => '80%',
		'100' => '100%'
	];
	
	/**
	 * Mise à jour ou initialisation du module
	 */
	private function update() {
		// Initialisation
		if ( null=== $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
			$this->init();	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			if( version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '1.1', '<') ){
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', '1.1']);
			}
		}
	}
	
	/**
	 * Initialisation
	 */
	private function init(){
		// Lexique
		$param = '';
		include('module/petition/lang/'. helper::lexlang($this->getData(['config', 'i18n', 'langBase']) , $this->getData(['config', 'i18n', 'langAdmin'])) . '/lex_form.php');
		$this->setData(['module', $this->getUrl(0),'texts',
			[
				'send' => $text['form_view']['text'][10],
				'name' => $text['form_view']['text'][11],
				'vorname' => $text['form_view']['text'][12],
				'mail' => $text['form_view']['text'][13],
				'numberResponses' => $text['form_view']['text'][14],
				'wrongCaptcha' => $text['form_view']['text'][15],
				'formSubmitted' => $text['form_view']['text'][16],
				'fillCaptcha' => $text['form_view']['text'][17],
				'mailAlreadyAnswered' => $text['form_view']['text'][19],
				'mailLinkClick' => $text['form_view']['text'][20],
				'mailAlreadyUsed' => $text['form_view']['text'][21],
				'youMustValidate' => $text['form_view']['text'][22],
				'alreadyValidated' => $text['form_view']['text'][23],
				'timeExpired' => $text['form_view']['text'][24],
				'validated' => $text['form_view']['text'][25],
				'linkNotActive' => $text['form_view']['text'][26],
				'alreadyResponded' => $text['form_view']['text'][27]
			]
		]);
		$this->setData(['module', $this->getUrl(0), 'config',
			[
				'versionData' => self::VERSION,
				'mail' => true,
				'captcha' => true,
				'validation' => true,
				'rgpdCheck' => true
			]
		]);
	}
	 
	 
	/**
	 * Configuration
	 */
	public function config() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < petition::$actions['config'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Soumission du formulaire
			if($this->isPost()) {
				// Configuration
				$this->setData([
					'module',
					$this->getUrl(0),
					'config',
					[
						'mail' => $this->getInput('formConfigMail', helper::FILTER_BOOLEAN),
						'captcha' => $this->getInput('formConfigCaptcha', helper::FILTER_BOOLEAN),
						'versionData' => self::VERSION,
						'validation' => $this->getInput('formConfigValidation', helper::FILTER_BOOLEAN),
						'rgpdCheck' => $this->getInput('formConfigRgpdCheck', helper::FILTER_BOOLEAN)
					]
				]);
				// Valeurs en sortie
				$this->addOutput([
					'notification' => $text['form']['config'][0],
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'state' => true
				]);
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['config'][1],
				'view' => 'config'
			]);
		}
	}

	/**
	 * Textes pour internationalisation
	 */
	public function texts() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < petition::$actions['texts'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Soumission du formulaire
			if($this->isPost()) {
				$this->setData(['module', $this->getUrl(0), 'texts',[
					'send' => $this->getInput('formTextsButton', helper::FILTER_STRING_SHORT),
					'name' => $this->getInput('formTextsName', helper::FILTER_STRING_SHORT),
					'vorname' => $this->getInput('formTextsVorname', helper::FILTER_STRING_SHORT),
					'mail' => $this->getInput('formTextsMail', helper::FILTER_STRING_SHORT),
					'noFields' => $this->getInput('formTextsNoFields', helper::FILTER_STRING_SHORT),
					'checked' => $this->getInput('formTextsChecked', helper::FILTER_STRING_SHORT),
					'noChecked' => $this->getInput('formTextsNoChecked', helper::FILTER_STRING_SHORT),
					'numberResponses' => $this->getInput('formTextsNumberResponses', helper::FILTER_STRING_SHORT),
					'results' => $this->getInput('formTextsResults', helper::FILTER_STRING_SHORT),
					'headingMissing' => $this->getInput('formTextsHeadingMissing', helper::FILTER_STRING_SHORT),
					'wrongCaptcha' => $this->getInput('formTextsWrongCaptcha', helper::FILTER_STRING_SHORT),
					'formSubmitted' => $this->getInput('formTextsFormSubmitted', helper::FILTER_STRING_SHORT),
					'fillCaptcha' => $this->getInput('formTextsFillCaptcha', helper::FILTER_STRING_SHORT),
					'mailAlreadyAnswered' => $this->getInput('formTextsMailAlreadyAnswered', helper::FILTER_STRING_SHORT),
					'mailLinkClick' => $this->getInput('formTextsMailLinkClick', helper::FILTER_STRING_SHORT),
					'mailAlreadyUsed' => $this->getInput('formTextsMailAlreadyUsed', helper::FILTER_STRING_SHORT),
					'youMustValidate' => $this->getInput('formTextsYouMustValidate', helper::FILTER_STRING_SHORT),
					'alreadyValidated' => $this->getInput('formTextsAlreadyValidated', helper::FILTER_STRING_SHORT),
					'timeExpired' => $this->getInput('formTextsTimeExpired', helper::FILTER_STRING_SHORT),
					'validated' => $this->getInput('formTextsValidated', helper::FILTER_STRING_SHORT),
					'linkNotActive' => $this->getInput('formTextsLinkNotActive', helper::FILTER_STRING_SHORT),
					'alreadyResponded' => $this->getInput('formTextsAlreadyResponded', helper::FILTER_STRING_SHORT)
				]]);
			
				$this->addOutput([
					'redirect' => helper::baseUrl() . $this->getUrl(0) . '/config',
					'notification' => $text['form']['texts'][1],
					'state' => true
				]);
				
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['texts'][0],
				'vendor' => [
					'html-sortable',
					'flatpickr'
				],
				'view' => 'texts'
			]);
		}
	}


	/**
	 * Données enregistrées
	 */
	public function data() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < petition::$actions['data'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
			if($data) {
				// Pagination
				$pagination = helper::pagination($data, $this->getUrl(),self::ITEMSPAGE);
				// Liste des pages
				self::$pages = $pagination['pages'];
				// Inverse l'ordre du tableau
				$dataIds = array_reverse(array_keys($data));
				$data = array_reverse($data);
				// Données en fonction de la pagination
				for($i = $pagination['first']; $i < $pagination['last']; $i++) {
					$content = '';
					if( isset($data[$i]['validation']['done']) && $data[$i]['validation']['done'] === false ) $content .= '<span style="font-style: italic;">'.$text['form']['data'][1] . '</span><br>';
					foreach($data[$i] as $key => $value) {
						if( ! is_array($value)){
							$content .= $key . ' : ' . $value . '<br>';
						}
					}
					self::$data[] = [
						$content,
						template::button('formDataDelete' . $dataIds[$i], [
							'class' => 'formDataDelete buttonRed',
							'href' => helper::baseUrl() . $this->getUrl(0) . '/delete/' . $dataIds[$i]  . '/' . $_SESSION['csrf'],
							'value' => template::ico('cancel')
						])
					];
				}
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['data'][0],
				'view' => 'data'
			]);
		}
	}


	/**
	 * Export CSV
	 */
	public function export2csv() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < petition::$actions['export2csv'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');	
			// Jeton incorrect
			if ($this->getUrl(2) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['export2csv'][0]
				]);
			} else {
				$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
				// Suppression des participations non validées et des données 'validation'
				foreach( $data as $id=>$value){
				  if( isset($value['validation']['done']) && $value['validation']['done'] === false){
					unset( $data[$id]);
				  }
				}
				foreach( $data as $id=>$value){
				  if( isset($value['validation'])){
					unset( $data[$id]['validation']);
				  }
				}
				if ($data !== []) {
					$csvfilename = 'data-'.date('dmY').'-'.date('Hi').'-'.rand(10,99).'.csv';
					if (!file_exists(self::FILE_DIR.'source/data')) {
						mkdir(self::FILE_DIR.'source/data', 0755);
					}
					$fp = fopen(self::FILE_DIR.'source/data/'.$csvfilename, 'w');
					// Récupérer les bonnes clefs
					foreach($data as $key=>$value){
						$tabdata = array_keys($data[$key]);
						break;
					}
					// $input est un code présent dans 'data' et 'input' il faut afficher le 'name' correspondant de 'input'
					foreach( $tabdata as $key1 => $val){
						foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $key2 => $tabval ){
							if( $tabval['id'] === $val ) $tabdata[$key1] = $tabval['name'];
						}	
					}
					fputcsv($fp, $tabdata , ';','"');
					foreach ($data as $fields) {
						fputcsv($fp, $fields, ';','"');
					}
					fclose($fp);
					// Valeurs en sortie
					$this->addOutput([
						'notification' => $text['form']['export2csv'][1].$csvfilename,
						'redirect' => helper::baseUrl() . $this->getUrl(0) .'/data',
						'state' => true
					]);
				} else {
					$this->addOutput([
						'notification' => $text['form']['export2csv'][2],
						'redirect' => helper::baseUrl() . $this->getUrl(0) .'/data'
					]);
				}
			}
		}
	}


	/**
	 * Suppression
	 */
	public function deleteall() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < petition::$actions['deleteall'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Jeton incorrect
			if ($this->getUrl(2) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['deleteall'][0]
				]);
			} else {
				$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
				if (count($data) > 0 ) {
					// Suppression multiple
					$this->setData(['data_module', $this->getUrl(0), 'data', [] ]);
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['deleteall'][1],
						'state' => true
					]);
				} else {
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['deleteall'][2]
					]);
				}
			}
		}
	}


	/**
	 * Suppression
	 */
	public function delete() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < petition::$actions['delete'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Jeton incorrect
			if ($this->getUrl(3) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['delete'][0]
				]);
			} else {
				// La donnée n'existe pas
				if($this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2)]) === null) {
					// Valeurs en sortie
					$this->addOutput([
						'access' => false
					]);
				}
				// Suppression
				else {
					$this->deleteData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2)]);					
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['delete'][1],
						'state' => true
					]);
				}
			}
		}
	}

	/**
	 *
	 * Validation de la signature par retour de courriel
	 */
	public function surveyValidation(){
		// Lexique
		$param = '';
		include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
		// Message avant ou après validation
		if( null !== $this->getUrl(2) ){
			// Traitement pour validation de la participation : participation validée ou temps dépassé ou participation déjà validée ou courriel déjà utilisé
			if( null !== $this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2), 'validation' ]) ){
				$dataval = $this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2), 'validation' ]);
				if($dataval['done']===true){
					self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'alreadyValidated']);
				} else {
					// contrôle de l'id
					if( $dataval['id'] !== $this->getUrl(3) ){
						self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'linkNotActive']);
					} else {
						// contrôle du timeout
						if( time() > ($dataval['time'] + 30*60) ){
							self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'timeExpired']);
						} else {
							// contrôle que l'adresse courriel n'a pas été utilisée pour une participation validée
							$countmail=0;
							foreach( $this->getData(['data_module', $this->getUrl(0), 'data' ]) as $id => $val){
								if( isset($val['validation']['mail']) && $val['validation']['mail'] === $dataval['mail'] && isset($val['validation']['done']) && $val['validation']['done'] === true) $countmail++;
							}
							if( $countmail > 0 ){
								self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'alreadyResponded']);
							} else {
								// validation de la participation
								$this->setData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2), 'validation', 'done', true ]);
								self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'validated']);
							}
						}
					}
				}
			} else {
				// Lien non actif
				self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'linkNotActive']);
			}
		} else {
			// Message d'invite à valider la participation
			self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'youMustValidate']);
		}
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => false,
			'view' => 'validation'
		]);	
	}


	/**
	 * Accueil
	 */
	public function index() {
		// Mise à jour du module
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) || version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<') ) $this->update();	
		// Lexique
		$param = '';
		$detectBot ='';
		include('module/petition/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
		// Soumission du formulaire
		if($this->isPost()) {
			// réponse validée par email à ce questionnaire déjà enregistrée ?
			$countmail=0;
			// lecture courriel
			$datamail = $this->getInput('formInputMail', helper::FILTER_MAIL,true);
			if( null !== $this->getData(['data_module', $this->getUrl(0), 'data' ]) ) {
				foreach( $this->getData(['data_module', $this->getUrl(0), 'data' ]) as $id => $val){
					if( $this->getData(['module', $this->getUrl(0), 'config', 'mail']) === true ){
						if( isset($val['validation']['mail']) && $val['validation']['mail'] === $datamail && isset($val['validation']['done']) && $val['validation']['done'] === true) $countmail++;
					} else {
						if( $val['mail'] === $datamail) $countmail++;
					}
				}
			}
			if(	$countmail > 0){
				$this->addOutput([
					'notification' => $this->getData(['module', $this->getUrl(0),'texts', 'mailAlreadyUsed']),
					'redirect' => helper::baseUrl() . $this->getUrl(0),
					'state' => false
				]);		
			} else {
				$notice_captcha = '';
				$code = isset($_REQUEST['codeCaptcha'] ) ? strtoupper($_REQUEST['codeCaptcha']) : '';
				// Captcha demandée
				if(	$this->getData(['module', $this->getUrl(0), 'config', 'captcha'])){
					// option de détection de robot en premier cochée et $_SESSION['humanBot']==='human'
					if(	$_SESSION['humanBot']==='human' && $this->getData(['config', 'connect', 'captchaBot'])=== true ) {
						// Présence des 6 cookies et checkbox cochée ?
						$detectBot ='bot';
						if ( isset ($_COOKIE['evtO']) && isset ($_COOKIE['evtV']) && isset ($_COOKIE['evtH']) 
							&& isset ($_COOKIE['evtS']) && isset ($_COOKIE['evtA']) && $this->getInput('formHumanCheck', helper::FILTER_BOOLEAN) === true ) {
							// Calcul des intervals de temps
							$time2 = $_COOKIE['evtH'] - $_COOKIE['evtO']; // temps entre click checkbox et ouverture de la page
							$time3 = $_COOKIE['evtV'] - $_COOKIE['evtH']; // temps entre validation formulaire et click checkbox
							$time4 = $_COOKIE['evtS'] - $_COOKIE['evtA']; // temps passé sur la checkbox
							if( $time2 >= 1000 && $time3 >=300 && $time4 >=300 
								&& $this->getInput('formInputBlue')==='' ) $detectBot = 'human';
						}
						// Bot présumé
						if( $detectBot === 'bot') $_SESSION['humanBot']='bot';
					}
					// $_SESSION['humanBot']==='bot' ou option 'Pas de Captcha pour un humain' non validée
					elseif( md5($code) !== $_SESSION['captcha'] ) {
						$notice_captcha = $this->getData(['module', $this->getUrl(0),'texts', 'wrongCaptcha']);
					}
				}	

				// Lecture nom, prénom, courriel
				$inputName = $this->getInput('formInputName', helper::FILTER_STRING_SHORT,true);
				$inputVorname = $this->getInput('formInputVorname', helper::FILTER_STRING_SHORT,true);
	
				// Ajout d'une notice sur la case à cocher d'acceptation des conditions si elle est utilisée et non cochée 
				if(	$this->getData(['module', $this->getUrl(0), 'config', 'rgpdCheck'])) $rgpdCheckbox = $this->getInput('formRgpdCheck', helper::FILTER_BOOLEAN,true);
				
				// Préparation des données pour la création dans la base				
				$data = []; 
				$data['name'] = $inputName;
				$data['vorname'] = $inputVorname;
				$data['mail'] = $datamail;
				$data['date'] = date("Y-m-d H:i");
				// Ajout des paramètres si validation par courriel
				if( $this->getData(['module', $this->getUrl(0), 'config', 'validation']) === true){
					$data['validation']['done'] = false;
					$data['validation']['time'] = time();
					$data['validation']['id'] = bin2hex(random_bytes(20));
					$data['validation']['mail'] = $datamail;
				}
				// Préparation du contenu du mail
				$content = $inputName.' '.$inputVorname.' '.$text['form']['index'][7];
				
				if( $detectBot === 'bot') $notice_captcha = $this->getData(['module', $this->getUrl(0),'texts', 'fillCaptcha']);
				
				$sent = true;
				if( $notice_captcha === '' && common::$inputNotices === []){
					// Crée les données (Pas d'enregistrement lorsqu'une notice est présente)
					$newId = null !== $this->getData(['data_module', $this->getUrl(0), 'data']) ? helper::increment(1, $this->getData(['data_module', $this->getUrl(0), 'data'])) : 1;
					$this->setData(['data_module', $this->getUrl(0), 'data', $newId, $data]);
					// Emission du mail aux gestionnaires de la pétition
					// Rechercher l'adresse en fonction du mail
					$singleuser = $this->getData(['user', $this->getData(['module', $this->getUrl(0), 'config', 'user']), 'mail']);
					$singlemail = $this->getData(['module', $this->getUrl(0), 'config', 'mail']);
					// Verification si le mail peut être envoyé
					if(	self::$inputNotices === [] && $this->getData(['module', $this->getUrl(0), 'config', 'mail']) === true ) {
						// Utilisateurs dans le groupe
						$to = [];
						foreach($this->getData(['user']) as $userId => $user) {
							// Modérateurs + administrateurs
							if($user['group'] >= 3) {
								$to[] = $user['mail'];
							}
						}
						if($to) {
							// Sujet du mail
							$subject = $text['form']['index'][1];
							// Envoi le mail
							$sent = $this->sendMail(
								$to,
								$subject,
								$text['form']['index'][2] . $this->getData(['page', $this->getUrl(0), 'title']) . '" :<br><br>' .
								$content
							);
						}
					}

					// Redirection
					$redirect = helper::baseUrl() . $this->getUrl(0);
					// Si validation de la participation par courriel envoi d'un mail avec le lien de validation et redirection spéciale
					if($this->getData(['module', $this->getUrl(0), 'config', 'validation']) === true){
						// Envoi du courriel au participant
						$to = $datamail;
						if($to) {
							// Sujet du mail
							$subject =  $this->getData(['module', $this->getUrl(0),'texts', 'mailAlreadyAnswered']) . helper::baseUrl(false);
							// Envoi le mail
							$sent = $this->sendMail(
								$to,
								$subject,
								$this->getData(['module', $this->getUrl(0),'texts', 'mailLinkClick']) .' '. $this->getData(['page', $this->getUrl(0), 'title']) . ' : <br><br>' .
								'<a href="'.helper::baseUrl() . $this->getUrl(0).'/surveyValidation/'.$newId.'/'.$data['validation']['id'].'" title="">'.$text['form']['index'][3].'</a>'
							);
						}
						// Redirection spéciale et prioritaire
						$redirect = helper::baseUrl() . $this->getUrl(0).'/surveyValidation';
					}
					
				} else {
					$sent = false;	
				}
					
				// Valeurs en sortie $sent false si $notice_captcha ou problème sur l'envoi du mail
				if( $sent !== true) {
					$_SESSION['humanBot']='bot';
					$redirect = helper::baseUrl() . $this->getUrl(0);
				}
				$this->addOutput([
					// la notification due aux entrées est prioritaire par rapport à celle due au captcha déclarée ici
					'notification' => ($sent === true ? $this->getData(['module', $this->getUrl(0),'texts', 'formSubmitted']) : $notice_captcha),
					'redirect' => $redirect,
					'state' => ($sent === true ? true : false)
				]);

			}
		}
		
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index'
		]);
	}
	
}
