<?php
/**
 * Simple Galerie Photo
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 * @copyright 2025 © Lionel Croquefer
 */
class photo extends common {
	public static $actions = [
		'index' => self::GROUP_VISITOR,
		'config' => self::GROUP_EDITOR,
		'sortPhotos' => self::GROUP_EDITOR
	];
	public static $listDirs = [];
	public static $photos = [];
	public static $photosId = [];

	const VERSION ='1.6';
	const REALNAME = 'Simple galerie photo';
	const DELETE = true;
	const UPDATE = '0.0';
	const DATADIRECTORY = '';
	const SORT_ASC = 'SORT_ASC';
	const SORT_DSC = 'SORT_DSC';
	const SORT_HAND = 'SORT_HAND';

	// Mise à jour de la version du module
	private function update() {
		if (null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
				$this->init();
			}
		else {
			// Version 1.3
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '1.3', '<') ) {
				$this->setData(['module',$this->getUrl(0),'config','thumbsize','240']);
				}
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<')) {
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
			}
		}
	}

	// Initialisation
	private function init() {
		$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
	}

	// Fonction de tri des photos dans config
	public function sortPhotos() {
		// Autorisation
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < photo::$actions['sortPhotos'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);
		} else {
		if($_POST['response']) {
			$data = explode('&',$_POST['response']);
			$data = str_replace('photoTable%5B%5D=','',$data);
			// Sauvegarder
			$this->setData(['module', $this->getUrl(0), [
			'config' => [
				'directory' => $this->getData(['module',$this->getUrl(0),'config','directory']),
				'spaceX' => $this->getData(['module',$this->getUrl(0),'config','spaceX']),
				'spaceY' => $this->getData(['module',$this->getUrl(0),'config','spaceY']),
				'sort' => $this->getData(['module',$this->getUrl(0),'config','sort']),
				'displaylegend' => $this->getData(['module',$this->getUrl(0),'config','displaylegend']),
				'border' => $this->getData(['module',$this->getUrl(0),'config','border']),
				'samespace' => $this->getData(['module',$this->getUrl(0),'config','samespace']),
				'thumbsize' => $this->getData(['module',$this->getUrl(0),'config','thumbsize'])
			],
			'legend' => $this->getData(['module',$this->getUrl(0),'legend']),
			'order' => array_flip($data)
			]]);
			}
		}
	}

	// Paramétrage du module,
	public function config() {
		// Autorisation
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if ($group < photo::$actions['config']) {
			// Valeurs en sortie
			$this->addOutput(['access' => false]);
		} else {
		// Lexique
		$param = '';
		include('./module/photo/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photo.php');

		// Liste les dossiers contenant des photos
		$filter = ['jpg','jpe','jpeg','gif','png','avif','webp'];
			self::$listDirs = helper::scanDir(self::FILE_DIR.'source', $filter);
			sort(self::$listDirs);

		// Valeurs par défaut si la galerie n'existe pas encore
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'directory'])) {
			$this->setData(['module', $this->getUrl(0), [
				'config' => [
					'directory' => self::$listDirs[0],
					'spaceX' => '0.5',
					'spaceY' => '0.5',
					'sort' => 'SORT_ASC',
					'displaylegend' => true,
					'border' => false,
					'samespace' => false,
					'thumbsize' => '240',
					'versionData' => self::VERSION
				],
				'legend' => [],
				'order' => []
			]]);
			// Valeurs en sortie
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0) . '/config',
				'notification' => 'Initialisation',
				'state' => true
			]);
		}

		// Formulaire posté
		if($this->isPost()) {
			$legends = [];
			foreach((array) $this->getInput('legend', null) as $file => $legend) {
				$file = str_replace('.','',$file);
				$legends[$file] = helper::filter($legend, helper::FILTER_STRING_SHORT);
			}
			// Enregistrement dans module.json
			$this->setData(['module', $this->getUrl(0), [
				'config' => [
				'directory' => self::$listDirs[$this->getInput('photoConfigDirectory')],
				'spaceX' => $this->getInput('configPhotoSpaceX'),
				'spaceY' => $this->getInput('configPhotoSpaceY'),
				'sort' =>  $this->getInput('photoConfigSort'),
				'displaylegend' => $this->getInput('photoConfigDisplayLegend', helper::FILTER_BOOLEAN),
				'border' => $this->getInput('photoConfigBorder', helper::FILTER_BOOLEAN),
				'samespace' => $this->getInput('photoConfigSameSpace', helper::FILTER_BOOLEAN),
				'thumbsize' => $this->getInput('photoConfigThumbSize'),
				'versionData' => self::VERSION
				],
				'legend' => $legends,
				'order' => $this->getData(['module', $this->getUrl(0), 'order'])
				]]);

			// Message et redirection après enregistrement de la configuration
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0),
				'notification' => $text['photo']['config'][0],
				'state' => true
				]);
			}

			// Préparation du tableau
			$directory = $this->getData(['module', $this->getUrl(0), 'config', 'directory']) ?? '_none_';
			if (is_dir($directory)) {
			$resultats = photoHelper::recherche($directory);
			foreach ($resultats as $fileFound) {
				if (photoHelper::autorise($fileFound)) {
					self::$photos[str_replace('.','',basename($fileFound))] = [
						template::ico('sort'),
						basename($fileFound),
						template::text('legend[' . basename($fileFound) . ']', [
							'value' => $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))])
						]),
						'<a href="'.$fileFound.'" rel="data-lity"><img class="config" src="'.photoHelper::makeThumbnail($fileFound,$this->getData(['module',$this->getUrl(0),'config','thumbsize'])).'" alt="preview"></a>'
					];
					self::$photosId[] = str_replace('.','',basename($fileFound));
				}
			}
			// Tri des photos dans le tableau config
			$order = $this->getData(['module',$this->getUrl(0),'order']);
			switch ($this->getData(['module', $this->getUrl(0), 'config', 'sort'])) {
				case self::SORT_HAND:
					if ($order) {
						$tempPhotos = $tempPhotosId = [];
						foreach ($order as $key => $value) {
							if (array_key_exists($key,self::$photos)) {
								$tempPhotos[$key] = self::$photos[$key];
								$tempPhotosId[] = $key;
							}
						}
						//Photos ayant été ajoutées dans le dossier mais non triées
						foreach (self::$photos as $key => $value) {
							if (!array_key_exists($key,$tempPhotos)) {
								$tempPhotos[$key] = self::$photos[$key];
								$tempPhotosId[] = $key;
							}
						}
						self::$photos = $tempPhotos;
						self::$photosId  = $tempPhotosId;
					}
					break;
				case self::SORT_ASC:
					ksort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					sort(self::$photosId,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				case self::SORT_DSC:
					krsort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					rsort(self::$photosId,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				}
			}

			// ALLER à la configuration du module
			$this->addOutput([
				'title' => $text['photo']['config'][1],
				'view' => 'config',
				'vendor' => ['tablednd']
			]);
		}
	}

	public function index() {
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ||  version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<') ) $this->update();
		// Lexique
		$param = '';
		include('./module/photo/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photo.php');

		// Module non configuré ?
		if (null === $this->getData(['module', $this->getUrl(0), 'config', 'directory' ])) {
			// ALLER à la configuration du module
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0).'/config',
				'notification' => $text['photo']['index'][0],
				'state' => true
			]);
		}

		$directory = $this->getData(['module', $this->getUrl(0), 'config', 'directory']) ?? '_none_';
			if (is_dir($directory)) {
			$resultats = photoHelper::recherche($directory);
			foreach ($resultats as $fileFound) {
				if (photoHelper::autorise($fileFound)) {
						self::$photos[basename($fileFound)] = $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))]);
						$photosSort[basename($fileFound)] = $this->getData(['module', $this->getUrl(0), 'order', str_replace('.','',basename($fileFound))]);
				}
			}
			// Tri des photos dans l'index
			switch ($this->getData(['module', $this->getUrl(0), 'config', 'sort'])) {
				case self::SORT_HAND:
					asort($photosSort);
					if ($photosSort) {
						foreach ($photosSort as $name => $position) {
							$temp[$name] = self::$photos[$name];
						}
						self::$photos = $temp;
					break;
					}
				case self::SORT_DSC:
					krsort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				case self::SORT_ASC:
				default:
					ksort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					break;
			}
		}

		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index'
		]);
	}
}//photo extends common

class photoHelper extends helper {
// création des dossiers
public static function makeDir($rep) {
	if (is_dir($rep)) {
		return true;
	} else {
		if (mkdir($rep)) { return true; }
		else { return false; }
	}
}
// Réécriture des noms
public static function separe($nom) {
	$separateurs = ['-','_','.'];
    return str_replace($separateurs, ' ', $nom);
}
// Limite de caractères
public static function smaller($nomcourt) {
$len = 30;
if (strlen($nomcourt) >= $len) {$nomcourt = substr($nomcourt,0,$len) . '...' ;}
   return $nomcourt;
   }
// Recherche de photos
public static function recherche($dossier) {
	$recherche = glob($dossier.'/*.{jp**,gif,png,avif,webp,JP**,GIF,PNG,AVIF,WEBP}', GLOB_BRACE);
	natcasesort($recherche);
	return $recherche;
}
// Filtrage par type mime
public static function autorise($fichier) {
	$allowed_types = ['jpeg','gif','png','avif','webp'];
	$photo_type = substr(strrchr(mime_content_type($fichier), '/'),1);
	return in_array($photo_type, $allowed_types);
}
// Thumbnailer
public static function makeThumbnail($foto,$taille) {
	if ( is_file($foto) && substr(mime_content_type($foto), 0, 5) == 'image' ) {
		// taille des miniatures
		$tnlarge = $taille;
		$tnhaut = ($tnlarge/1.6);

		$dossiercache = 'site/file/simplecache';
		self::makeDir($dossiercache);
		$cache = substr(strrchr(dirname($foto), '/'), 1);
		self::makeDir($dossiercache.'/'.$cache);

		$par = basename($foto);
		$extension = strrchr($par,'.');
		$vignette = str_replace($extension,'',$par);
		$miniature = $dossiercache.'/'.$cache.'/'.$taille.'-'.$vignette.'-'.filesize($foto).'.webp';

		if (!file_exists($miniature)) {
			list($width, $height, $type, $attr) = getimagesize($foto);

			if ($height > $tnhaut) {
			$convert = $tnhaut/$height;
			$height = $tnhaut;
			$width = ceil($width*$convert);
			}
			if ($width > $tnlarge) {
			$convert = $tnlarge/$width;
			$width = $tnlarge;
			$height = ceil($height*$convert);
			}

			$largeur = (int)round($width);
			$hauteur = (int)round($height);

		switch ($type) {
			case 1:
			$img_in = imagecreatefromgif($foto);
			break;
			case 2:
			$img_in = imagecreatefromjpeg($foto);
			break;
			case 3:
			$img_in = imagecreatefrompng($foto);
			break;
			case 18:
			$webpContents = file_get_contents($foto);
			$anim = ( strpos($webpContents, 'ANIM') !== false || strpos($webpContents, 'ANMF') !== false );
			if ($anim === false) {
			$img_in = imagecreatefromwebp($foto);
			}
			else { $img_in = false; }
			break;
			case 19:
			$img_in = function_exists('imagecreatefromavif') ? imagecreatefromavif($foto) : false;
			break;
		}

			if (false !== $img_in) {
				imageinterlace($img_in, true);
				$img_out = imagecreatetruecolor($largeur, $hauteur) or die ('Unable to create a GD image stream');
			if ($type !== 2) {
				imagecolortransparent($img_out, imagecolorallocatealpha($img_out, 0, 0, 0, 127));
				imagealphablending($img_out, false);
				imagesavealpha($img_out, true);
			}
				imagecopyresampled($img_out, $img_in, 0, 0, 0, 0, imagesx($img_out), imagesy($img_out), imagesx($img_in), imagesy($img_in));
				imagewebp($img_out, $miniature, 80);
				imagedestroy($img_out);
			} else { $miniature = $foto; }
		}
		return $miniature;
		clearstatcache();
	}
	else { return false; }
} // makeThumbnail
// class
}
