/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */

// Tri dynamique de la galerie photo
$( document ).ready(function() {
	$("#photoTable").tableDnD({
		onDrop: function(table, row) {
			$("#photoConfigFormResponse").val($.tableDnD.serialize());
			sortPhotos();
		},
		serializeRegexp:  ""
	});
	if ($("#photoConfigSort").val() !==  "SORT_HAND") {
		$("#photoTable tr").addClass("nodrag nodrop");
		$(".delta-ico-sort").hide();
		$("#photoTable").tableDnDUpdate();
	} else {
		$("#photoTable tr").removeClass("nodrag nodrop");
		$(".delta-ico-sort").show();
		$("#photoTable").tableDnDUpdate();
	}
});

$("#photoConfigSort").change(function() {
	if ($("#photoConfigSort").val() !==  "SORT_HAND") {
		$("#photoTable tr").addClass("nodrag nodrop");
		$(".delta-ico-sort").hide();
		$("#photoTable").tableDnDUpdate();
	} else {
		$("#photoTable tr").removeClass("nodrag nodrop");
		$(".delta-ico-sort").show();
		$("#photoTable").tableDnDUpdate();
	}
});

// Tri dynamique des photos
function sortPhotos() {
	var url = "<?=helper::baseUrl() . $this->getUrl(0)?>/sortPhotos";
	var d1 = $("#photoConfigFormResponse").val();
	$.ajax({
		type: "POST",
		url: url,
		data: {
			response : d1,
		}
	});
}

// Affiche / Cache l'option légende
$("#configPhotoSpaceY").on("change", function() {
	if($(this).val() === '0') {
		$("#photoConfigDisplayLegendWrapper").hide();
	} else {
		$("#photoConfigDisplayLegendWrapper").show();
	}
}).trigger("change");
