<?php
/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */
$param = "photo_view";
include('./module/photo/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photo.php');
echo template::formOpen('photoConfigForm');
?>
<div class="row">
	<div class="col2">
		<?php echo template::button('photoConfigBack', [
			'class' => 'buttonGrey',
			'href' => helper::baseUrl() . 'page/edit/' . $this->getUrl(0),
			'ico' => 'left',
			'value' => $text['photo_view']['config'][0]
		]); ?>
	</div>
	<div class="col2 offset8">
		<?php echo template::submit('photoConfigSubmit', [
			'value' => $text['photo_view']['config'][1]
		]); ?>
	</div>
</div>
<div class="row">
	<div class="col12">
		<div class="block">
			<div class="blockTitle"><?php echo $text['photo_view']['config'][2]; ?></div>
			<div class="row">
				<div class="col3">
					<?php echo template::select('photoConfigDirectory', str_replace('site/file/source/','',$module::$listDirs), [
						'label' => $text['photo_view']['config'][3],
						'selected' => array_search($this->getData(['module', $this->getUrl(0), 'config', 'directory']), $module::$listDirs)
					]); ?>
				</div>
				<div class="col3">
					<?php echo template::select('configPhotoSpaceX', $spaceX, [
						'label' => $text['photo_view']['config'][5],
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'spaceX'])
					]); ?>
				</div>
				<div class="col3">
					<?php echo template::select('configPhotoSpaceY', $spaceY, [
						'label' => $text['photo_view']['config'][6],
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'spaceY'])
					]); ?>
				</div>
				<div class="col3">
					<?php echo template::select('photoConfigSort', $sort, [
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'sort']),
						'label' => $text['photo_view']['config'][7]
					]); ?>
				</div>
			</div>
			<div class="row">
				<div class="col2">
					<?php echo template::checkbox('photoConfigDisplayLegend', true, $text['photo_view']['config'][8], [
						'checked' => (bool) $this->getData(['module', $this->getUrl(0), 'config', 'displaylegend']),
						'help' => $text['photo_view']['config'][9]
					]); ?>
				</div>
				<div class="col2">
				<?php echo template::checkbox('photoConfigBorder', true, $text['photo_view']['config'][10], [
					'checked' => $this->getData(['module', $this->getUrl(0), 'config', 'border']),
					'help' => $text['photo_view']['config'][11]
				]); ?>
				</div>
				<div class="col2">
					<?php echo template::checkbox('photoConfigSameSpace', true, $text['photo_view']['config'][12], [
						'checked' => (bool) $this->getData(['module', $this->getUrl(0), 'config', 'samespace']),
						'help' => $text['photo_view']['config'][13]
					]); ?>
				</div>
				<div class="col3 offset3">
					<?php echo template::select('photoConfigThumbSize', $thumbSize, [
						'label' => $text['photo_view']['config'][14],
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'thumbsize'])
					]); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
if($module::$photos):
	echo template::table([1, 3, 7, 1], $module::$photos, ['', $text['photo_view']['edit'][0], $text['photo_view']['edit'][1], ''],['id' => 'photoTable'], $module::$photosId);
	echo template::hidden('photoConfigFormResponse');
endif;
echo template::formClose();
?>
<div class="moduleVersion">
	<?=$text['photo_view']['config'][4].$module::VERSION?>
</div>
