<?php
/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */
$large = $this->getData(['module',$this->getUrl(0),'config','thumbsize']) ?? 240;
$haut = ($large/1.6);
?>
#photos {
	width: 100%;
	display: flex;
	flex-direction: row;
	flex-wrap: wrap;
	justify-content: center;
	align-items: center;
}
#photos > .photo {
	display: inline-flex;
	justify-content: safe center;
	align-items: center;
	margin: <?=$this->getData(['module', $this->getUrl(0), 'config', 'spaceY'])?>rem <?=$this->getData(['module', $this->getUrl(0), 'config', 'spaceX'])?>rem;
}
#photos > .photo img {
	display: block;
	width: auto;
	max-width: <?=$large?>px;
	height: auto;
	max-height: <?=$haut?>px;
	padding: 0;
	margin: 0 auto;
}
#photos > .photo a {
	color: <?=$this->getData(['theme', 'site', 'scrollUaDColor'])?>;
	text-decoration: none;
}
#photos > .photo a:hover {
	color: <?=$this->getData(['theme', 'text', 'textColor'])?>;
}
#photos > .photo span {
	display: block;
	padding: 1px 2px;
	margin: 0;
	text-align: center;
	font-size: 10px;
	font-weight: 600;
	white-space: nowrap;
	overflow: hidden;
	background-color: <?=$this->getData(['theme', 'site', 'ScrollUaDbackgroundColor'])?>;
	border-radius: <?=$this->getData(['theme', 'block', 'blockBorderRadius'])?>;
}
.photoborder {
	border: 1px solid <?=$this->getdata(['theme','block','borderColor'])?>;
	border-radius: <?=$this->getdata(['theme','block','blockBorderRadius'])?>;
	box-shadow : <?=$this->getdata(['theme','block','blockBorderShadow'])?> <?=$this->getdata(['theme','block','borderColor'])?>;
}
.noborder {
	border: none;
}
<?php
if ($this->getData(['module',$this->getUrl(0),'config','spaceY']) == 0) {
?>
#photos > .photo {
	max-height: <?=$haut?>px;
}
#photos > .photo span {
	display: none;
}
<?php
}
if ( $this->getData(['module',$this->getUrl(0),'config','samespace']) === true ) {
?>
#photos {
	justify-content: center;
}
#photos > .photo {
	display: inline-block;
	width: <?=$large?>px;
}
#photos > .photo span {
	width: 100% !important;
}
<?php
}
?>
@media (max-width: 480px) and (orientation: portrait) {
	#photos > .photo img, #photos > .photo span {
		max-width: 95vmin !important;
}
}
