<?php
/**
 * Simple géolocalisation de photos
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 * @copyright 2025 © Lionel Croquefer
 */
class photolocation extends common {
	public static $actions = [
		'index' => self::GROUP_VISITOR,
		'config' => self::GROUP_EDITOR,
		'sortPhotos' => self::GROUP_EDITOR
	];
	public static $listDirs = [];
	public static $photos = [];
	public static $photosId = [];
	public static $locations = [];

	const VERSION ='2.0';
	const REALNAME = 'Simple géolocalisation de photos';
	const DELETE = true;
	const UPDATE = '0.0';
	const DATADIRECTORY = '';
	const SORT_ASC = 'SORT_ASC';
	const SORT_DSC = 'SORT_DSC';
	const SORT_HAND = 'SORT_HAND';

	// Mise à jour de la version du module
	private function update() {
		if (null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
				$this->init();
			}
		else {
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<')) {
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
			}
		}
	}

	// Initialisation
	private function init() {
		$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
	}

	// Fonction de tri des photos dans config
	public function sortPhotos() {
		// Autorisation
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < photolocation::$actions['sortPhotos'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);
		} else {
		if($_POST['response']) {
			$data = explode('&',$_POST['response']);
			$data = str_replace('photolocationTable%5B%5D=','',$data);
			// Sauvegarder
			$this->setData(['module', $this->getUrl(0), [
			'config' => [
				'directory' => $this->getData(['module',$this->getUrl(0),'config','directory']),
				'spaceX' => $this->getData(['module',$this->getUrl(0),'config','spaceX']),
				'spaceY' => $this->getData(['module',$this->getUrl(0),'config','spaceY']),
				'sort' => $this->getData(['module',$this->getUrl(0),'config','sort']),
				'displaylegend' => $this->getData(['module',$this->getUrl(0),'config','displaylegend']),
				'border' => $this->getData(['module',$this->getUrl(0),'config','border'])
			],
			'legend' => $this->getData(['module',$this->getUrl(0),'legend']),
			'order' => array_flip($data)
			]]);
			}
		}
	}

	// Paramétrage du module,
	public function config() {
		// Autorisation
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if ($group < photolocation::$actions['config']) {
			// Valeurs en sortie
			$this->addOutput(['access' => false]);
		} else {
		// Lexique
		$param = '';
		include('./module/photolocation/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photolocation.php');

		// Liste les dossiers contenant des photos compatibles avec EXIF GPS
		$filter = ['jpg','jpe','jpeg'];
			self::$listDirs = helper::scanDir(self::FILE_DIR.'source', $filter);
			sort(self::$listDirs);

		// Formulaire posté
		if($this->isPost()) {
			$legends = [];
			foreach((array) $this->getInput('legend', null) as $file => $legend) {
				$file = str_replace('.','',$file);
				$legends[$file] = helper::filter($legend, helper::FILTER_STRING_SHORT);
			}
			// Enregistrement dans module.json
			$this->setData(['module', $this->getUrl(0), [
				'config' => [
				'directory' => self::$listDirs[$this->getInput('photolocationConfigDirectory')],
				'spaceX' => $this->getInput('photolocationConfigSpaceX'),
				'spaceY' => $this->getInput('photolocationConfigSpaceY'),
				'sort' =>  $this->getInput('photolocationConfigSort'),
				'displaylegend' => $this->getInput('photolocationConfigDisplayLegend', helper::FILTER_BOOLEAN),
				'border' => $this->getInput('photolocationConfigBorder', helper::FILTER_BOOLEAN),
				'versionData' => self::VERSION
				],
				'legend' => $legends,
				'order' => $this->getData(['module', $this->getUrl(0), 'order'])
				]]);

			// Message et redirection après enregistrement de la configuration
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0),
				'notification' => $text['photolocation']['config'][0],
				'state' => true
				]);
			}

			// Préparation du tableau config
			$directory = $this->getData(['module', $this->getUrl(0), 'config', 'directory']) ?? '_none_';
			if (is_dir($directory)) {
			$resultats = photolocationHelper::recherche($directory);
			foreach ($resultats as $fileFound) {
				if (photolocationHelper::autorise($fileFound)) {
					// Recherche et récupération des métadonnées EXIF GPS
					$get_location = photolocationHelper::gps_exif($fileFound);
					$latitude = $get_location['latitude'] ?? 0;
					$longitude = $get_location['longitude'] ?? 0;
					// Mise en forme du tableau
					self::$photos[str_replace('.','',basename($fileFound))] = [
						template::ico('sort'),
						basename($fileFound),
						template::text('legend[' . basename($fileFound) . ']', [
							'value' => $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))])
						]),
						'<a href="'.$fileFound.'" rel="data-lity"><img class="preview" src="'.photolocationHelper::makeThumbnail($fileFound).'" alt="preview"></a>'
					];
					self::$photosId[] = str_replace('.','',basename($fileFound));
				}
			}

			// Tri des photos dans le tableau config
			$order = $this->getData(['module',$this->getUrl(0),'order']);
			switch ($this->getData(['module', $this->getUrl(0), 'config', 'sort'])) {
				case self::SORT_HAND:
					if ($order) {
						$tempPhotos = $tempPhotosId = [];
						foreach ($order as $key => $value) {
							if (array_key_exists($key,self::$photos)) {
								$tempPhotos[$key] = self::$photos[$key];
								$tempPhotosId[] = $key;
							}
						}
						// Photos ayant été ajoutées dans le dossier mais non triées
						foreach (self::$photos as $key => $value) {
							if (!array_key_exists($key,$tempPhotos)) {
								$tempPhotos[$key] = self::$photos[$key];
								$tempPhotosId[] = $key;
							}
						}
						self::$photos = $tempPhotos;
						self::$photosId  = $tempPhotosId;
					}
					break;
				case self::SORT_ASC:
					ksort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					sort(self::$photosId,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				case self::SORT_DSC:
					krsort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					rsort(self::$photosId,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				}
			}

			// ALLER à la configuration du module
			$this->addOutput([
				'title' => $text['photolocation']['config'][1],
				'view' => 'config',
				'vendor' => ['tablednd']
			]);
		}
	}

	public function index() {
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ||  version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<') ) $this->update();
		// Lexique
		$param = '';
		include('./module/photolocation/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photolocation.php');

		// Module non configuré ?
		if (null === $this->getData(['module', $this->getUrl(0), 'config', 'directory' ])) {
			// ALLER à la configuration du module
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0).'/config',
				'notification' => $text['photolocation']['index'][0],
				'state' => true
			]);
		}

		$directory = $this->getData(['module', $this->getUrl(0), 'config', 'directory']) ?? '_none_';
			if (is_dir($directory)) {
			$resultats = photolocationHelper::recherche($directory);
			foreach ($resultats as $fileFound) {
				if (photolocationHelper::autorise($fileFound)) {
					self::$photos[basename($fileFound)] = $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))]);
					$photosSort[basename($fileFound)] = $this->getData(['module', $this->getUrl(0), 'order', str_replace('.','',basename($fileFound))]);
					// Recherche et récupération des métadonnées EXIF GPS
					$get_location = photolocationHelper::gps_exif($fileFound);
						// Transmission à l'index
						$legendepopup = $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))]);
						if ($get_location !== null) { self::$locations[] = [
							'lat' => $get_location['latitude'],
							'lon' => $get_location['longitude'],
							'id' => $get_location['fileid'],
							'img' => $fileFound,
							'tn' => photolocationHelper::makeThumbnail($fileFound),
							'cap' => is_null($legendepopup) ? '' : htmlspecialchars($legendepopup, ENT_QUOTES)
						];
					}
				}//autorise
			}//foreach

			// Tri des photos dans l'index
			switch ($this->getData(['module', $this->getUrl(0), 'config', 'sort'])) {
				case self::SORT_HAND:
					asort($photosSort);
					if ($photosSort) {
						foreach ($photosSort as $name => $position) {
							$temp[$name] = self::$photos[$name];
						}
						self::$photos = $temp;
					break;
					}
				case self::SORT_DSC:
					krsort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				case self::SORT_ASC:
				default:
					ksort(self::$photos,SORT_NATURAL | SORT_FLAG_CASE);
					break;
			}//switch
		}// is_dir

		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index',
			'vendor' => ['leaflet'],
		]);
	}//function index
}//photolocation extends common

class photolocationHelper extends helper {
// relevés exif gps des photos
public static function gps_exif($foto) {
if (function_exists('exif_read_data')) {
	$exif = @exif_read_data($foto, 0, true);
	if ($exif && isset($exif['GPS']['GPSLongitudeRef']) && !empty($exif['GPS']['GPSLongitude'][0])) {
		$latitude = self::gps($exif['GPS']['GPSLatitude'], $exif['GPS']['GPSLatitudeRef']);
		$longitude = self::gps($exif['GPS']['GPSLongitude'], $exif['GPS']['GPSLongitudeRef']);
        $filename = $exif['FILE']['FileName'];
		if ( (!isset($latitude) || !isset($longitude)) || (($latitude == 0) && ($longitude == 0)) ) {
			return false;
			}
		else {
			return ['latitude'=>$latitude, 'longitude'=>$longitude, 'fileid'=>preg_replace('/[^\da-z]/i', '', 'sgp'.$filename)];
			}
		}
	}
}
public static function gps($coordinate, $hemisphere) {
	if (is_string($coordinate)) {
		$coordinate = array_map('trim', explode(',', $coordinate));
	}
	for ($i = 0; $i < 3; $i++) {
		$part = explode('/', $coordinate[$i]);
		if (count($part) == 1) {
			$coordinate[$i] = $part[0];
			} elseif ( (count($part) == 2) && ($part[1] > 0) ) {
				$coordinate[$i] = floatval($part[0])/floatval($part[1]);
			} else {
			$coordinate[$i] = 0;
		}
	}
	list($degrees, $minutes, $seconds) = $coordinate;
	$sign = ($hemisphere == 'W' || $hemisphere == 'S') ? -1 : 1;
	return $sign * ($degrees + $minutes/60 + $seconds/3600);
}
// création des dossiers
public static function makeDir($rep) {
	if (is_dir($rep)) {
		return true;
	} else {
		if (mkdir($rep)) { return true; }
		else { return false; }
	}
}
// Réécriture des noms
public static function separe($nom) {
	$separateurs = ['-','_','.'];
    return str_replace($separateurs, ' ', $nom);
}
// Limite de caractères
public static function smaller($nomcourt) {
	$shorten = helper::subword($nomcourt, 0, 30);
	if (strlen($shorten) < strlen($nomcourt)) $nomcourt = $shorten.'...';
	return $nomcourt;
}
// Recherche de photos
public static function recherche($dossier) {
	$recherche = glob($dossier.'/*.{jp**,JP**}', GLOB_BRACE);
	natcasesort($recherche);
	return $recherche;
}
// Filtrage par type mime
public static function autorise($fichier) {
	$allowed_type = ['jpeg'];
	$photo_type = substr(strrchr(mime_content_type($fichier), '/'),1);
	return in_array($photo_type, $allowed_type);
}
// Thumbnailer
public static function makeThumbnail($foto) {
	if ( is_file($foto) && substr(strrchr(mime_content_type($foto), '/'),1) == 'jpeg' ) {
		// taille des miniatures
		$tnlarge = 200;
		$tnhaut = ($tnlarge/1.6);

		$dossiercache = 'site/file/simplecache';
		self::makeDir($dossiercache);
		$cache = substr(strrchr(dirname($foto), '/'), 1);
		self::makeDir($dossiercache.'/'.$cache);

		$par = basename($foto);
		$extension = strrchr($par,'.');
		$vignette = str_replace($extension,'',$par);
		$miniature = $dossiercache.'/'.$cache.'/sgp-'.$vignette.'-'.filesize($foto).'.webp';

	if (!file_exists($miniature)) {
		list($width, $height, $type, $attr) = getimagesize($foto);

		if ($height > $tnhaut) {
		$convert = $tnhaut/$height;
		$height = $tnhaut;
		$width = ceil($width*$convert);
		}
		if ($width > $tnlarge) {
		$convert = $tnlarge/$width;
		$width = $tnlarge;
		$height = ceil($height*$convert);
		}

		$largeur = (int)round($width);
		$hauteur = (int)round($height);

		$img_in = imagecreatefromjpeg($foto);
		imageinterlace($img_in, true);
		$img_out = imagecreatetruecolor($largeur, $hauteur) or die ('Unable to create a GD image stream');
		imagecopyresampled($img_out, $img_in, 0, 0, 0, 0, imagesx($img_out), imagesy($img_out), imagesx($img_in), imagesy($img_in));
		imagewebp($img_out, $miniature, 80);
		imagedestroy($img_out);
	}
	return $miniature;
	clearstatcache();
	}
	else { return false; }
} // makeThumbnail
// class
}
