/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */

// Tri dynamique de la galerie photo
$( document ).ready(function() {
	$("#photolocationTable").tableDnD({
		onDrop: function(table, row) {
			$("#photolocationConfigFormResponse").val($.tableDnD.serialize());
			sortPhotos();
		},
		serializeRegexp:  ""
	});
	if ($("#photolocationConfigSort").val() !==  "SORT_HAND") {
		$("#photolocationTable tr").addClass("nodrag nodrop");
		$(".delta-ico-sort").hide();
		$("#photolocationTable").tableDnDUpdate();
	} else {
		$("#photolocationTable tr").removeClass("nodrag nodrop");
		$(".delta-ico-sort").show();
		$("#photolocationTable").tableDnDUpdate();
	}
});

$("#photolocationConfigSort").change(function() {
	if ($("#photolocationConfigSort").val() !==  "SORT_HAND") {
		$("#photolocationTable tr").addClass("nodrag nodrop");
		$(".delta-ico-sort").hide();
		$("#photolocationTable").tableDnDUpdate();
	} else {
		$("#photolocationTable tr").removeClass("nodrag nodrop");
		$(".delta-ico-sort").show();
		$("#photolocationTable").tableDnDUpdate();
	}
});

// Tri dynamique des photos
function sortPhotos() {
	var url = "<?=helper::baseUrl() . $this->getUrl(0)?>/sortPhotos";
	var d1 = $("#photolocationConfigFormResponse").val();
	$.ajax({
		type: "POST",
		url: url,
		data: {
			response : d1,
		}
	});
}

// Affiche / Cache l'option légende
$("#photolocationConfigSpaceY").on("change", function() {
	if($(this).val() === '0') {
		$("#photolocationConfigDisplayLegendWrapper").hide();
	} else {
		$("#photolocationConfigDisplayLegendWrapper").show();
	}
}).trigger("change");
