<?php
/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */
$param = "photolocation_view";
include('./module/photolocation/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photolocation.php');
echo template::formOpen('photolocationConfigForm');
?>
<div class="row">
	<div class="col2">
		<?php echo template::button('photolocationConfigBack', [
			'class' => 'buttonGrey',
			'href' => helper::baseUrl() . 'page/edit/' . $this->getUrl(0),
			'ico' => 'left',
			'value' => $text['photolocation_view']['config'][0]
		]); ?>
	</div>
	<div class="col2 offset8">
		<?php echo template::submit('photolocationConfigSubmit', [
			'value' => $text['photolocation_view']['config'][1]
		]); ?>
	</div>
</div>
<div class="row">
	<div class="col12">
		<div class="block">
			<div class="blockTitle"><?php echo $text['photolocation_view']['config'][2]; ?></div>
			<div class="row">
				<div class="col3">
					<?php echo template::select('photolocationConfigDirectory', str_replace('site/file/source/','',$module::$listDirs), [
						'label' => $text['photolocation_view']['config'][3],
						'selected' => array_search($this->getData(['module', $this->getUrl(0), 'config', 'directory']), $module::$listDirs)
					]); ?>
				</div>
				<div class="col3">
					<?php echo template::select('photolocationConfigSpaceX', $spaceX, [
						'label' => $text['photolocation_view']['config'][5],
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'spaceX'])
					]); ?>
				</div>
				<div class="col3">
					<?php echo template::select('photolocationConfigSpaceY', $spaceY, [
						'label' => $text['photolocation_view']['config'][6],
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'spaceY'])
					]); ?>
				</div>
				<div class="col3">
					<?php echo template::select('photolocationConfigSort', $sort, [
						'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'sort']),
						'label' => $text['photolocation_view']['config'][7]
					]); ?>
				</div>
			</div>
			<div class="row">
				<div class="col2">
					<?php echo template::checkbox('photolocationConfigDisplayLegend', true, $text['photolocation_view']['config'][8], [
						'checked' => (bool) $this->getData(['module', $this->getUrl(0), 'config', 'displaylegend']),
						'help' => $text['photolocation_view']['config'][9]
					]); ?>
				</div>
				<div class="col2">
				<?php echo template::checkbox('photolocationConfigBorder', true, $text['photolocation_view']['config'][10], [
					'checked' => $this->getData(['module', $this->getUrl(0), 'config', 'border']),
					'help' => $text['photolocation_view']['config'][11]
				]); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php
if($module::$photos):
	echo template::table([1, 3, 7, 1], $module::$photos, ['', $text['photolocation_view']['edit'][0], $text['photolocation_view']['edit'][1], $text['photolocation_view']['edit'][2]], ['id' => 'photolocationTable'], $module::$photosId);
	echo template::hidden('photolocationConfigFormResponse');
endif;
echo template::formClose();
?>
<div class="moduleVersion">
	<?=$text['photolocation_view']['config'][4].$module::VERSION?>
</div>
