/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */
section {
	scrollbar-color: <?=$this->getData(['theme', 'site', 'scrollUaDColor'])?> <?=$this->getData(['theme', 'site', 'ScrollUaDbackgroundColor'])?>;
}
section > #photos {
	width: 100%;
	height: <?php echo ($this->getData(['module',$this->getUrl(0),'config','displaylegend']) == true) ? 155 : 142; ?>px;
	<?php if ($_SESSION['terminal'] === 'mobile') { ?>
	overflow-x: auto;
	overflow-y: hidden;
	<?php } else { ?>
	overflow: hidden;
	<?php } ?>
	display: inline-flex;
	flex-direction: row;
	flex-wrap: nowrap;
	align-items: center;
}
section > #photos > .photo {
	position: relative;
	display: inline-block;
	margin: <?=$this->getData(['module', $this->getUrl(0), 'config', 'spaceY'])?>rem <?=$this->getData(['module', $this->getUrl(0), 'config', 'spaceX'])?>rem;
}
section > #photos > .photo img {
	display: block;
	width: auto;
	max-width: 200px;
	height: auto;
	max-height: 125px;
	padding: 0;
	margin: 0 auto;
}
section > #photos > .photo a {
	color: <?=$this->getData(['theme', 'site', 'scrollUaDColor'])?>;
	text-decoration: none;
}
section > #photos > .photo a:hover {
	color: <?=$this->getData(['theme', 'text', 'textColor'])?>;
}
section > #photos > .photo span {
	display: block;
	padding: 1px 2px;
	margin: 0;
	text-align: center;
	font-size: 10px;
	font-weight: 600;
	white-space: nowrap;
	overflow: hidden;
	background-color: <?=$this->getData(['theme', 'site', 'ScrollUaDbackgroundColor'])?>;
	border-radius: <?=$this->getData(['theme', 'block', 'blockBorderRadius'])?>;
}
section > #navignette {
	width: 100%;
	height: 20px;
	display: block;
	position: relative;
	margin-bottom: 2px;
}
button.navhorizon {
	position: absolute;
	width: 40px;
	height: 20px;
	border-radius: 3px;
	background-color: rgb(0 0 0 /0);
	border: 2px outset <?=$this->getData(['theme', 'text', 'textColor'])?>;
	color: <?=$this->getData(['theme', 'text', 'textColor'])?>;
	padding: 0;
}
button.navhorizon:hover {
	border-style: inset;
}
button#navhorizon-prev {
	top: 0;
	left: 0;
}
button#navhorizon-next {
	top: 0;
	right: 0;
}
.photoborder {
	border: 1px solid <?=$this->getdata(['theme','block','borderColor'])?>;
	border-radius: <?=$this->getdata(['theme','block','blockBorderRadius'])?>;
	box-shadow : <?=$this->getdata(['theme','block','blockBorderShadow'])?> <?=$this->getdata(['theme','block','borderColor'])?>;
}
.noborder {
	border: none;
}
.zoom-on-map {
	position: absolute;
	top: 2px;
	right: 2px;
	width: 20px;
	height: 20px;
	border-radius: 50%;
	background-color: rgb(0 0 0 /0);
	border: 2px solid coral;
	}
<?php
if ($this->getData(['module',$this->getUrl(0),'config','spaceY']) == 0) {
?>
section > #photos {
	height: 125px;
}
section > #photos > .photo {
	max-height: 125px;
}
section > #photos > .photo span {
	display: none;
}
<?php
}
?>
#map {
	height: 65vh;
	width: 100%;
	background: #333;
	z-index: 1;
}
/* leaflet */
.leaflet-popup-content-wrapper {
	 background-color: #333 !important;
	 border-radius: 3px !important;
}
.leaflet-popup-tip {
	 background-color: #111 !important;
}
.leaflet-popup-close-button {
	 display: none;
}
.leaflet-popup-content {
	margin : 4px !important;
	width: 167px;
	height: auto;
}
.leaflet-popup-content img {
	display: block;
	margin: 0 auto;
}
.leaflet-popup-content span {
	font: caption;
	color: #eee;
}
.leaflet-control-layers-list {
	min-height: 10%;
	padding: 4px;
	margin: 0;
	text-align: left;
	border: none;
}
@media (max-width: 799px) {
.leaflet-control-attribution {
	display: none;
}
}
