/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */
	$(document).ready(function () {

const satellite = L.tileLayer('https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}', {
		maxZoom: 19,
		maxNativeZoom: 18,
		attribution: '&copy; Esri',
	});
const osm = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
		maxZoom: 19,
		attribution: '&copy; OpenStreetMap'
	});
const ohm = L.tileLayer('https://tile.openmaps.fr/opentopomap/{z}/{x}/{y}.png', {
		maxZoom: 19,
		maxNativeZoom: 18,
		attribution: '&copy; OpenHikingMap | SRTM (CC-BY-SA)'
	});
const mri = L.tileLayer('https://maps.refuges.info/hiking/{z}/{x}/{y}.png', {
		maxZoom: 19,
		maxNativeZoom: 18,
		attribution: '&copy; OpenStreetMap/ODbL | SRTM (CC-BY-SA)'
	});

	const json = '<?=json_encode($module::$locations)?>';
	const obj = JSON.parse(json);

	let circleLoc = new L.circle();

	obj.forEach(function (zoomOnLocation) {
	document.querySelector('#'+zoomOnLocation.id).addEventListener("click", () => {
		map.flyTo([zoomOnLocation.lat, zoomOnLocation.lon], 18);
		map.on('zoomend', function(e) {
	    map.removeLayer(circleLoc);
        circleLoc = new L.circle([zoomOnLocation.lat, zoomOnLocation.lon], {
		radius: 6,
		opacity: 0.8,
		fill : false,
		stroke: true,
		weight: 3,
		color: 'coral'
		});
		map.addLayer(circleLoc);
		});
	});
});

const map = L.map('map',{
	layers: [osm],
	fullscreenControl: true,
	fullscreenControlOptions: {
	position: 'topleft'
}
}).setView([40, 0], 3);

const baseLayers = {
	'Satellite' : satellite,
	'OpenStreetMap': osm,
	'OpenHikingMap': ohm,
	'MapsRefugesInfo': mri
};

let layerControl = L.control.layers(baseLayers).addTo(map);

let scaleOptions = {
	position: 'bottomleft',
	metric: true,
	imperial: false
};
let scaleControl = L.control.scale(scaleOptions);
	scaleControl.addTo(map);

let markers = L.markerClusterGroup();
let MyIcon = L.Icon.extend({
	options: {
	   iconSize:     [38, 38],
	   iconAnchor:   [22, 3],
	   popupAnchor:  [1, 0]
	}
});
let PixIcon = new MyIcon({
	iconUrl: 'module/photolocation/vendor/leaflet/images/appareil-photo.png',
});

  obj.forEach(function (photoLocation) {
	const marker = L.marker([photoLocation.lat, photoLocation.lon], {icon: PixIcon, title: "lat: " + (photoLocation.lat).toFixed(6) +" lon: "+ (photoLocation.lon).toFixed(6)});
	marker.bindPopup('<span>' + photoLocation.cap + '</span><img src="' + photoLocation.tn + '" alt="Vignette">');
	marker.on('mouseover', function (e) {
		this.openPopup();
	});
	marker.on('mouseout', function (e) {
		this.closePopup();
	});
	marker.on('click', function(e) {
		map.flyTo(e.latlng, 18);
	});
	markers.addLayer(marker);
  });
	map.addLayer(markers);
	map.fitBounds(markers.getBounds());
});

$(function() {
	if ($('#photos').get(0).scrollWidth > $('#photos').innerWidth()) {
	  $('#navignette').show();
	} else {
	  $('#navignette').hide();
	}

  $('#navhorizon-prev').click(function(event) {
    event.preventDefault();
    $('#photos').animate({
      scrollLeft: "-=600px"
    }, "slow");
  });

   $('#navhorizon-next').click(function(event) {
    event.preventDefault();
    $('#photos').animate({
     scrollLeft: "+=600px"
    }, "slow");
  });
});
