<?php
/**
 * This file is part of Deltacms
 * @license GNU General Public License, version 3
 * @copyright 2025 © Lionel Croquefer
 */
$param = '';
include('./module/photolocation/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_photolocation.php');
$PhotoBorder = $this->getData(['module', $this->getUrl(0), 'config', 'border']) === true ? 'photoborder' : 'noborder';
?>
<!-- version <?php echo $module::VERSION .' de '. $module::REALNAME; ?> -->
<div id="photos">
<?php
	$dossier_choisi = $this->getData(['module', $this->getUrl(0), 'config', 'directory']);
if (is_dir($dossier_choisi) && !empty($module::$locations)) {
foreach($module::$photos as $photo => $legend):
	$url_fichier = $dossier_choisi.'/'.$photo;
	$nom_fichier = str_replace(strrchr($photo, '.'),'',$photo);
	$id_fichier = preg_replace('/[^\da-z]/i', '', $photo);
	$miniature = photolocationHelper::makeThumbnail($url_fichier);
	list($width, $height) = getimagesize($miniature);
	echo '<div class="photo">'.
	'<a href="'.$url_fichier.'" rel="gallery" data-caption="'.$legend.'">'.
	'<img src="'.$miniature.'" alt="'.$legend.'" title="'.photolocationHelper::separe($nom_fichier).'" class="'.$PhotoBorder.'" width="'.$width.'" height="'.$height.'">';
	 if ( $this->getData(['module',$this->getUrl(0),'config','displaylegend']) === true ) {
		if (!empty($legend)) {
			echo '<span style="max-width: '.$width.'px;" data-tippy-content="'.$legend.'">'.photolocationHelper::smaller($legend).'</span>';
		}
		else {
			echo '<span style="max-width: '.$width.'px;">'.photolocationHelper::smaller(photolocationHelper::separe($nom_fichier)).'</span>';
		}
	}
	echo '</a>';
	// ajout du marqueur aux images contenant des données exif gps
	$control_exif = @exif_read_data($url_fichier);
		if (!empty($control_exif['GPSLatitude']) && !empty($control_exif['GPSLongitude'])) {
			echo '<button id="sgp'.$id_fichier.'" class="zoom-on-map" title="zoom"></button>';
		}
	echo '</div>'.PHP_EOL;
endforeach;
} else { echo template::speech($text['photolocation_view']['index'][0]); }
?>
</div>
<?php if ($_SESSION['terminal'] === 'desktop') { ?>
<div id="navignette">
<button class="navhorizon delta-ico-left-open" id="navhorizon-prev"></button>
<button class="navhorizon delta-ico-right-open" id="navhorizon-next"></button>
</div>
<?php } if (!empty($module::$locations)) { echo '<div id="map"></div>'; } ?>
