<?php

/**
 * This file is part of DeltaCMS.
 * For full copyright and license information, please see the LICENSE
 * file that was distributed with this source code.
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2021, Sylvain Lelièvre
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 *
 * Delta was created from version 11.2.00.24 of ZwiiCMS
 * @author Rémi Jean <remi.jean@outlook.com>
 * @copyright Copyright (C) 2008-2018, Rémi Jean
 * @author Frédéric Tempez <frederic.tempez@outlook.com>
 * @copyright Copyright (C) 2018-2021, Frédéric Tempez
 *
 * Module Snipcart pour e-commerce
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2020, Sylvain Lelièvre
 */

class snipcart extends common {

	public static $actions = [
		'config' => self::GROUP_EDITOR,
		'index' => self::GROUP_VISITOR
	];


	const VERSION = '2.1';	
	const REALNAME = 'Snipcart';
	const DELETE = true;
	const UPDATE = '0.0';
	const DATADIRECTORY = self::DATA_DIR.'snipcart/';
	
	// Dossier des données du module externes à module.json
	const DATAMODULE = self::DATA_DIR.'snipcart/module'; 
	
	/**
	* Mise à jour du module
	* Appelée par les fonctions index et config
	*/
	private function update() {
		//Lexique
		include('./module/snipcart/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_snipcart.php');
		// Initialisation
		if( null === $this->getData(['module', $this->getUrl(0), 'config'])){
			$this->setData(['module', $this->getUrl(0), 'config',[
				'valid' => false,
				'key' => '',
				'poids' => '1',
				'taxes' => 'TVA 20%',
				'transport' => true,
				'buttonText' => $text['snipcart_view']['config'][30],
				'buttonWidth' => '150',
				'buttonColor' => 'rgba(33, 34, 35, 1)',
				'buttonBgColor' => 'rgba(162, 223, 57, 1)',
				'template' => 'bouton_seul',
				'versionData' => self::VERSION
			]]);
		} else {
			// Mise à jour vers 1.4
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '1.4', '<') ) {			
				// Déplacement de datadefault.json de site/data/snipcart vers site/data/snipcart/module 
				if( is_file( 'site/data/snipcart/datadefault.json')){
					rename('site/data/snipcart/datadefault.json', self::DATAMODULE.'/datadefault.json');
					unlink('site/data/snipcart/interdits.html');
					unlink('site/data/snipcart/snipcart_mode_emploi.pdf');
					
				}
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData','1.4']);
			}
		
			// Version 2.1
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '2.1', '<') ) {
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData','2.1']);
			}	
		}
	}
	
	/**
	 * Configuration
	 */
	public function config() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < snipcart::$actions['config'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			//Lexique
			include('./module/snipcart/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_snipcart.php');
			// Mise à jour des données de module
			$this->update();
		
			// Soumission du formulaire
			if($this->isPost()) {
				$this->setData(['module', $this->getUrl(0), 'config',[
					'valid' => $this->getInput('snipcartConfigValid', helper::FILTER_BOOLEAN),
					'key' => $this->getInput('snipcartConfigKey', helper::FILTER_STRING_SHORT),
					'poids' => $this->getInput('snipcartConfigPoids', helper::FILTER_STRING_SHORT),
					'taxes' => $this->getInput('snipcartConfigTaxes', helper::FILTER_STRING_SHORT),
					'transport' => $this->getInput('snipcartConfigTransport', helper::FILTER_BOOLEAN),
					'buttonText' => $this->getInput('snipcartConfigText', helper::FILTER_STRING_SHORT),
					'buttonWidth' => $this->getInput('snipcartConfigWidth', helper::FILTER_STRING_SHORT),
					'buttonColor' => $this->getInput('snipcartConfigColor', helper::FILTER_STRING_SHORT),
					'buttonBgColor' => $this->getInput('snipcartConfigBgColor', helper::FILTER_STRING_SHORT),
					'template' => $this->getInput('snipcartConfigTemplate', helper::FILTER_STRING_SHORT),
					'versionData' => $this->getData(['module', $this->getUrl(0), 'config', 'versionData'])
				]]);
			
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'notification' => 'Modifications enregistrées',
					'state' => true
				]);
			}
			else{
				// Pour compatibilité avec version 1.1
				if( null === $this->getData(['module', $this->getUrl(0), 'config','template'])){
					$template = 'bouton_seul';
				}
				else{
					$template = $this->getData(['module', $this->getUrl(0), 'config','template']);
				}
				
				// Modification du fichier datadefault.json
				$data = [];
				$data["poids"] = $this->getData(['module', $this->getUrl(0), 'config','poids']);
				$data["taxes"] = $this->getData(['module', $this->getUrl(0), 'config','taxes']);
				$data["transport"] = $this->getData(['module', $this->getUrl(0), 'config','transport']);
				$data["buttonText"] = $this->getData(['module', $this->getUrl(0), 'config','buttonText']);
				$data["buttonWidth"] = $this->getData(['module', $this->getUrl(0), 'config','buttonWidth']);
				$data["buttonColor"] = $this->getData(['module', $this->getUrl(0), 'config','buttonColor']);
				$data["buttonBgColor"] = $this->getData(['module', $this->getUrl(0), 'config','buttonBgColor']);
				$data["template"] = $template;
				$json = json_encode($data);
				file_put_contents( self::DATAMODULE.'/datadefault.json', $json);
			
				// Si snipcart est activé on vérifie s'il faut compléter le fichier head.inc.html
				if($this->getData(['module', $this->getUrl(0), 'config','valid']) === true
				&& $this->getData(['module', $this->getUrl(0), 'config','key']) != ''){
				
					// head.inc.html
					$str=[];
					$str[0] = '<?php // Module snipcart inclusion dans head';
					$str[1] = 'if($this->getData([\'page\', $this->getUrl(0), \'moduleId\']) === \'snipcart\'){';
					$str[2] = 'echo \'<script> window.SnipcartSettings = { publicApiKey: "\'.$this->getData([\'module\', $this->getUrl(0), \'config\',\'key\']).\'", loadStrategy: "on-user-interaction", version: "3.4.0",};\';';
					$str[3] = 'include ("site/data/snipcart/module/snipcart.min.js");';
					$str[4] = 'echo "</script>"; }';
					$str[5] = '// Module snipcart fin d\'inclusion ?>';
					$strhead ='';
					foreach($str as $key=>$value){
						$strhead = $strhead.$value."\r\n";
					}
					// Si le fichier head.inc.html existe
					if( file_exists( './site/data/head.inc.html' )){
						$file = file_get_contents( './site/data/head.inc.html' );
						// Quelques chaînes ne sont pas trouvées 
						if( strpos( $file, $str[0]) === false || strpos( $file, $str[5]) === false  ){
							file_put_contents( './site/data/head.inc.html', $file."\r\n".$strhead);
						}
					}
					else{
						file_put_contents( './site/data/head.inc.html', $strhead);
					}
				
				}
			
				// Valeurs en sortie
				$this->addOutput([
					'title' => $text['snipcart']['config'][0],
					'vendor' => [
						'tinycolorpicker'
					],
					'view' => 'config'
				]);
			}
		}
	}


	/**
	 * Fonction index()
	*/
	 
	public function index() {
	
		// Mise à jour des données de module
		$this->update();	
	
		// Pour compatibilité avec version 1.1
		if( null === $this->getData(['module', $this->getUrl(0), 'config','template'])){
			$template = 'bouton_seul';
		}
		else{
			$template = $this->getData(['module', $this->getUrl(0), 'config','template']);
		}
		
		// Mise à jour du fichier datadefault.json à l'ouverture de chaque page boutique
		// Ces paramètres sont propres à la page boutique et mémorisés dans module.json
		$data = [];
		$data["poids"] = $this->getData(['module', $this->getUrl(0), 'config','poids']);
		$data["taxes"] = $this->getData(['module', $this->getUrl(0), 'config','taxes']);
		$data["transport"] = $this->getData(['module', $this->getUrl(0), 'config','transport']);
		$data["buttonText"] = $this->getData(['module', $this->getUrl(0), 'config','buttonText']);
		$data["buttonWidth"] = $this->getData(['module', $this->getUrl(0), 'config','buttonWidth']);
		$data["buttonColor"] = $this->getData(['module', $this->getUrl(0), 'config','buttonColor']);
		$data["buttonBgColor"] = $this->getData(['module', $this->getUrl(0), 'config','buttonBgColor']);
		$data["template"] = $template;
		$json = json_encode($data);
		file_put_contents( self::DATAMODULE.'/datadefault.json', $json);
					
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index'
		]);

	}
}
?>
