<?php 
//Configuration du module snipcart pour Deltacms
include('./module/snipcart/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_snipcart.php');

echo template::formOpen('snipcartConfigForm'); ?>
	<div class="row">
		<div class="col2">
			<?php echo template::button('snipcartConfigBack', [
				'class' => 'buttonGrey',
				'href' => helper::baseUrl() . 'page/edit/' . $this->getUrl(0),
				'ico' => 'left',
				'value' => $text['snipcart_view']['config'][0]
			]); ?>
		</div>
		<div class="col2 offset8">
			<?php echo template::submit('snipcartConfigSubmit', [
				'ico' => ''
			]); ?>
		</div>
	</div>
	
	<div class="block" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?> >
		<div class="blockTitle"><?php echo $text['snipcart_view']['config'][1]; ?></div>
		<div class="row">
			<div class="col4">
				<p></p>
				<?php echo template::checkbox('snipcartConfigValid', true, $text['snipcart_view']['config'][2], [
					'checked' => $this->getData(['module', $this->getUrl(0),'config','valid' ]),
					'help' => $text['snipcart_view']['config'][3]
				]); ?>
			</div>
		</div>
		<div class="row">
			<div class="col12">
			<?php echo template::text('snipcartConfigKey', [
					'help' => $text['snipcart_view']['config'][4],
					'label' => 'API KEY',
					'value' => $this->getData(['module', $this->getUrl(0),'config','key' ])
				]); ?>
			</div>
		</div>
	</div>
	
	<?php	// Lecture de datadefault.json
	$filejson = file_get_contents($module::DATAMODULE.'/datadefault.json');
	$datajson = json_decode($filejson, true);
	?>
	
	<div class="block" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?> >
		<div class="blockTitle"><?php echo $text['snipcart_view']['config'][5]; ?></div>
		<div class="row">
			<div class="col8">
				<?php // Pour compatibilité avec version 1.1
				if( null === $this->getData(['module', $this->getUrl(0), 'config','template'])){
					$template = 'bouton_seul';
				}
				else{
					$template = $this->getData(['module', $this->getUrl(0), 'config','template']);
				}?>
				<?php echo template::select('snipcartConfigTemplate', $choixTemplate,[
					'help' => $text['snipcart_view']['config'][6],
					'label' => $text['snipcart_view']['config'][7],
					'selected' => $template
				]); ?>
			</div>
		</div>
	</div>
	
	<div class="block">
		<div class="blockTitle"><?php echo $text['snipcart_view']['config'][8]; ?></div>
		<div class="row">
			<div class="col4">
			<?php echo template::text('snipcartConfigPoids', [
					'label' => $text['snipcart_view']['config'][11],
					'value' => $this->getData(['module', $this->getUrl(0),'config','poids'])
				]); ?>
			</div>
			<div class="col4 offset4">
			<?php echo template::text('snipcartConfigTaxes', [
					'help' => $text['snipcart_view']['config'][12],
					'label' => $text['snipcart_view']['config'][13],
					'value' => $this->getData(['module', $this->getUrl(0),'config','taxes'])
				]); ?>
			</div>
		</div>
		<div class="row">
			<div class="col4">
				<p></p>
				<?php echo template::checkbox('snipcartConfigTransport', true, $text['snipcart_view']['config'][14], [
					'checked' => $this->getData(['module', $this->getUrl(0),'config','transport']),
					'help' => $text['snipcart_view']['config'][15]
				]); ?>
			</div>
		</div>	
		
	</div>
	
	<div class="block">
		<div class="blockTitle"><?php echo $text['snipcart_view']['config'][16]; ?></div>
		<div class="row">
			<div class="col4">
			<?php echo template::text('snipcartConfigText', [
					'help' => $text['snipcart_view']['config'][17],
					'label' => $text['snipcart_view']['config'][18],
					'value' => $this->getData(['module', $this->getUrl(0),'config','buttonText'])
				]); ?>
			</div>
			<div class="col4 offset4">
			<?php echo template::text('snipcartConfigWidth', [
					'help' => $text['snipcart_view']['config'][19],
					'label' => $text['snipcart_view']['config'][20],
					'value' => $this->getData(['module', $this->getUrl(0),'config','buttonWidth'])
				]); ?>
			</div>
		</div>
		<div class="row">
			<div class="col4">
			<?php echo template::text('snipcartConfigColor', [
					'class' => 'colorPicker',
					'help' => $text['snipcart_view']['config'][21],
					'label' => $text['snipcart_view']['config'][22],
					'value' => $this->getData(['module', $this->getUrl(0),'config','buttonColor'])
				]); ?>
			</div>
			<div class="col4 offset4">
			<?php echo template::text('snipcartConfigBgColor', [
					'class' => 'colorPicker',
					'help' => $text['snipcart_view']['config'][23],
					'label' => $text['snipcart_view']['config'][24],
					'value' => $this->getData(['module', $this->getUrl(0),'config','buttonBgColor'])
				]); ?>
			</div>
		</div>		
	</div>
	
	
	<div class="block">
	<div class="blockTitle"><?php echo $text['snipcart_view']['config'][25];?></div>
	<p style="text-align: left;"><a href="https://app.snipcart.com/" target="_blank" rel="noopener" title="Page de connexion du site Snipcart"><?php echo $text['snipcart_view']['config'][26];?></a></p>
	<p style="text-align: left;"><a href="https://deltacms.fr/site/file/source/modules/documentations/<?php echo $text['snipcart_view']['config'][29];?>" target="_blank" title="Documentation Snipcart" rel="noopener"><?php echo $text['snipcart_view']['config'][27];?></a></p>
	</div>

<?php echo template::formClose(); ?>
<div class="moduleVersion"><?php echo $text['snipcart_view']['config'][28];?>
	<?php echo $module::VERSION; ?>
</div>
