<?php

/**
 * This file is part of DeltaCMS.
 * For full copyright and license information, please see the LICENSE
 * file that was distributed with this source code.
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2021, Sylvain Lelièvre
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 *
 * Delta was created from version 11.2.00.24 of ZwiiCMS
 * @author Rémi Jean <remi.jean@outlook.com>
 * @copyright Copyright (C) 2008-2018, Rémi Jean
 * @author Frédéric Tempez <frederic.tempez@outlook.com>
 * @copyright Copyright (C) 2018-2021, Frédéric Tempez
 */
 
class sondage extends common {

	const VERSION = '1.8';
	const REALNAME = 'Sondage';
	const DELETE = true;
	const UPDATE = '0.0';
	//const DATADIRECTORY = ''; // Contenu localisé inclus par défaut (page.json et module.json)
	
	

	public static $actions = [
		'config' => self::GROUP_EDITOR,
		'update' => self::GROUP_EDITOR,
		'data' => self::GROUP_MODERATOR,
		'question' => self::GROUP_MODERATOR,
		'delete' => self::GROUP_MODERATOR,
		'deleteall' => self::GROUP_MODERATOR,
		'index' => self::GROUP_VISITOR,
		'export2csv' => self::GROUP_MODERATOR,
		'selectMul' => self::GROUP_VISITOR,
		'setDataModule' => self::GROUP_EDITOR,
		'deleteDataModule' => self::GROUP_MODERATOR,
		'getDataModule' => self::GROUP_VISITOR
	];

	public static $data = [];

	public static $pages = [];

	public static $pagination;
	


	// Objets
	const TYPE_MAIL = 'mail';
	const TYPE_SELECT = 'select';
	const TYPE_SELECT_MUL = 'selectMultiple';
	const TYPE_TEXT = 'text';
	const TYPE_TEXTAREA = 'textarea';
	const TYPE_CHECKBOX = 'checkbox';
	const TYPE_LABEL = 'label';
	const ITEMSPAGE = 10;

	public static $listUsers = [
	];
	
	public static $logoWidth = [
		'40' => '40%',
		'60' => '60%',
		'80' => '80%',
		'100' => '100%'
	];
	
	/**
	 * Mise à jour du module
	 */
	public function update() {
		// Initialisation
		if ( null=== $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
			$this->setData(['module', $this->getUrl(0), 'config', 'versionData', '1.6']);	
		}
		if( version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '1.8', '<') ){
			$this->setData(['module', $this->getUrl(0), 'config', 'versionData', '1.8']);
		}
	}
	
	
	/**
	 * Configuration
	 */
	public function config() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['config'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Liste des utilisateurs
			$userIdsFirstnames = helper::arrayCollumn($this->getData(['user']), 'firstname');
			ksort($userIdsFirstnames);
			self::$listUsers [] = '';
			foreach($userIdsFirstnames as $userId => $userFirstname) {
				self::$listUsers [] =  $userId;
			}
			// Soumission du formulaire
			if($this->isPost()) {
				// Configuration
				$this->setData([
					'module',
					$this->getUrl(0),
					'config',
					[
						'button' => $this->getInput('formConfigButton'),
						'captcha' => $this->getInput('formConfigCaptcha', helper::FILTER_BOOLEAN),
						'group' => $this->getInput('formConfigGroup', helper::FILTER_INT),
						'user' =>  self::$listUsers [$this->getInput('formConfigUser', helper::FILTER_INT)],
						'mail' => $this->getInput('formConfigMail') ,
						'pageId' => $this->getInput('formConfigPageIdToggle', helper::FILTER_BOOLEAN) === true ? $this->getInput('formConfigPageId', helper::FILTER_ID) : '',
						'subject' => $this->getInput('formConfigSubject'),
						'signature' => $this->getInput('formConfigSignature'),
						'logoUrl' => $this->getInput('formConfigLogo'),
						'logoWidth' => $this->getInput('formConfigLogoWidth'),
						'versionData' => self::VERSION,
						'groupStat' => $this->getInput('formConfigGroupStat', helper::FILTER_INT),
						'visibleForm' => $this->getInput('formConfigVisibleForm', helper::FILTER_BOOLEAN)
					]
				]);
				// Génération des données vides
				if ($this->getData(['data_module', $this->getUrl(0), 'data']) === null) {
					$this->setData(['data_module', $this->getUrl(0), 'data', []]);
				}
				// Génération des champs
				$inputs = [];
				foreach($this->getInput('formConfigPosition', null) as $index => $position) {
					// Si l'id n'existe pas on le crée
					if( null !== $this->getData(['module', $this->getUrl(0), 'input', $index , 'id']) ){
						$ident = $this->getData(['module', $this->getUrl(0), 'input', $index, 'id']);
					} else {
						$ident = rand(1000000,9999999);
					}
					// suppression des espaces avant ou après les virgules dans les values
					$values_ok = $this->getInput('formConfigValues[' . $index . ']');
					$values_ok = preg_replace('/\s*,\s*/', ',', trim($values_ok));
					// suppression d'une virgule terminale dans les values
					if( substr($values_ok, -1) === ',') $values_ok = substr($values_ok,0,-1);
					$inputs[] = [
						'id' => $ident,
						'name' => htmlspecialchars_decode($this->getInput('formConfigName[' . $index . ']'),ENT_QUOTES),
						'position' => helper::filter($position, helper::FILTER_INT),
						'required' => $this->getInput('formConfigRequired[' . $index . ']', helper::FILTER_BOOLEAN),
						'type' => $this->getInput('formConfigType[' . $index . ']'),
						'values' => $values_ok,
						'nbcara' => $this->getInput('formConfigSelect[' . $index . ']'),
						'richquestion' => $this->getInput('formConfigRichQuestion[' . $index . ']', helper::FILTER_BOOLEAN)
					];
				}
				$this->setData(['module', $this->getUrl(0), 'input', $inputs]);
				// Valeurs en sortie
				$this->addOutput([
					'notification' => $text['form']['config'][0],
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'state' => true
				]);
			}
			// Liste des pages
			foreach($this->getHierarchy(null, false) as $parentPageId => $childrenPageIds) {
				self::$pages[$parentPageId] = $this->getData(['page', $parentPageId, 'title']);
				foreach($childrenPageIds as $childKey) {
					self::$pages[$childKey] = '&nbsp;&nbsp;&nbsp;&nbsp;' . $this->getData(['page', $childKey, 'title']);
				}
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['config'][1],
				'vendor' => [
					'html-sortable',
					'flatpickr'
				],
				'view' => 'config'
			]);
		}
	}

	/**
	 * Données enregistrées
	 */
	public function data() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['data'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
			if($data) {
				// Pagination
				$pagination = helper::pagination($data, $this->getUrl(),self::ITEMSPAGE);
				// Liste des pages
				self::$pages = $pagination['pages'];
				// Inverse l'ordre du tableau
				$dataIds = array_reverse(array_keys($data));
				$data = array_reverse($data);
				// Données en fonction de la pagination
				for($i = $pagination['first']; $i < $pagination['last']; $i++) {
					$content = '';
					foreach($data[$i] as $input => $value) {
						// $input est un code présent dans 'data' et 'input' il faut afficher le 'name' correspondant de 'input'
						foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $key => $tabval ){
							if( $tabval['id'] === $input ) $name = $tabval['name'];
						}
						if( $name === "") $name = $text['form_view']['index'][7];
						$content .= $name . ' : ' . $value . '<br>';
					}
					self::$data[] = [
						$content,
						template::button('formDataDelete' . $dataIds[$i], [
							'class' => 'formDataDelete buttonRed',
							'href' => helper::baseUrl() . $this->getUrl(0) . '/delete/' . $dataIds[$i]  . '/' . $_SESSION['csrf'],
							'value' => template::ico('cancel')
						])
					];
				}
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['data'][0],
				'view' => 'data'
			]);
		}
	}

	/**
	 * Rédaction des questions avec Tinymce
	 */
	public function question() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['question'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Soumission du formulaire
			if($this->isPost()) {
				// Enregistrement des questions
				foreach($this->getData(['module', $this->getUrl(0), 'input']) as $key => $input){
					if( $input['richquestion'] === true){
						$content = empty($this->getInput('formQuestion['. $key .']', null)) ? '<p></p>' : str_replace('<p></p>', '', $this->getInput('formQuestion['. $key .']', null));
						$this->setData(['module', $this->getUrl(0), 'question', $input['id'], $content ]);	
						
						
					}
				}
				// Valeurs en sortie
				$this->addOutput([
					'notification' => $text['form']['question'][1],
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'state' => true
				]);
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['question'][0],
				'vendor' => ['tinymce'],
				'view' => 'question'
			]);		
		}
	}

	/**
	 * Export CSV
	 */
	public function export2csv() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['export2csv'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');	
			// Jeton incorrect
			if ($this->getUrl(2) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['export2csv'][0]
				]);
			} else {
				$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
				if ($data !== []) {
					$csvfilename = 'data-'.date('dmY').'-'.date('hm').'-'.rand(10,99).'.csv';
					if (!file_exists(self::FILE_DIR.'source/data')) {
						mkdir(self::FILE_DIR.'source/data', 0755);
					}
					$fp = fopen(self::FILE_DIR.'source/data/'.$csvfilename, 'w');
					// $input est un code présent dans 'data' et 'input' il faut afficher le 'name' correspondant de 'input'
					$tabdata = array_keys($data[1]);
					foreach( $tabdata as $key1 => $val){
						foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $key2 => $tabval ){
							if( $tabval['id'] === $val ) $tabdata[$key1] = $tabval['name'];
						}	
					}
					fputcsv($fp, $tabdata , ';','"');
					foreach ($data as $fields) {
						fputcsv($fp, $fields, ';','"');
					}
					fclose($fp);
					// Valeurs en sortie
					$this->addOutput([
						'notification' => $text['form']['export2csv'][1].$csvfilename,
						'redirect' => helper::baseUrl() . $this->getUrl(0) .'/data',
						'state' => true
					]);
				} else {
					$this->addOutput([
						'notification' => $text['form']['export2csv'][2],
						'redirect' => helper::baseUrl() . $this->getUrl(0) .'/data'
					]);
				}
			}
		}
	}


	/**
	 * Suppression
	 */
	public function deleteall() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['deleteall'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Jeton incorrect
			if ($this->getUrl(2) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['deleteall'][0]
				]);
			} else {
				$data = ($this->getData(['data_module', $this->getUrl(0), 'data']));
				if (count($data) > 0 ) {
					// Suppression multiple
					for ($i = 1; $i <= count($data) ; $i++) {
						echo $this->deleteData(['data_module', $this->getUrl(0), 'data', $i]);
					}
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['deleteall'][1],
						'state' => true
					]);
				} else {
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['deleteall'][2]
					]);
				}
			}
		}
	}


	/**
	 * Suppression
	 */
	public function delete() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['delete'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Jeton incorrect
			if ($this->getUrl(3) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['delete'][0]
				]);
			} else {
				// La donnée n'existe pas
				if($this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2)]) === null) {
					// Valeurs en sortie
					$this->addOutput([
						'access' => false
					]);
				}
				// Suppression
				else {
					$this->deleteData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2)]);					
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['delete'][1],
						'state' => true
					]);
				}
			}
		}
	}




	/**
	 * Accueil
	 */
	public function index() {
		// Mise à jour du module
		$this->update();
		// Lexique
		$param = '';
		$detectBot ='';
		include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
		// Création du brouillon s'il n'existe pas
		if( !isset($_SESSION[$this->getUrl()]['draft'])){
			$_SESSION[$this->getUrl()]['draft'] = [];
			$_SESSION[$this->getUrl()]['draft']['mail'] = "";
			$_SESSION[$this->getUrl()]['draft']['textarea'] = [];
			$_SESSION[$this->getUrl()]['draft']['checkbox'] = [];
			$_SESSION[$this->getUrl()]['draft']['select'] = [];
			$_SESSION[$this->getUrl()]['draft']['selectMultiple'] = [];
			$_SESSION[$this->getUrl()]['draft']['text'] = [];			
		}
		// Soumission du formulaire
		if($this->isPost()) {
			// réponse valide à ce questionnaire, dans cette langue, déjà enregistrée pour cette session
			if( isset($_SESSION[$this->getUrl()][self::$i18n]['sondage_done']) && $_SESSION[$this->getUrl()][self::$i18n]['sondage_done']=== true){
				$this->addOutput([
					'notification' => $text['form']['index'][14],
					'redirect' => helper::baseUrl() . $this->getUrl(0),
					'state' => false,
					'vendor' => [
						'flatpickr',
						'tinymce'
					]
				]);
				
			} else {
				$notice_captcha = '';
				$code = isset($_REQUEST['codeCaptcha'] ) ? strtoupper($_REQUEST['codeCaptcha']) : '';
				// Captcha demandée
				if(	$this->getData(['module', $this->getUrl(0), 'config', 'captcha'])){
					// option de détection de robot en premier cochée et $_SESSION['humanBot']==='human'
					if(	$_SESSION['humanBot']==='human' && $this->getData(['config', 'connect', 'captchaBot'])=== true ) {
						// Présence des 6 cookies et checkbox cochée ?
						$detectBot ='bot';
						if ( isset ($_COOKIE['evtC']) && isset ($_COOKIE['evtO']) && isset ($_COOKIE['evtV']) && isset ($_COOKIE['evtH']) 
							&& isset ($_COOKIE['evtS']) && isset ($_COOKIE['evtA']) && $this->getInput('formHumanCheck', helper::FILTER_BOOLEAN) === true ) {
							// Calcul des intervals de temps
							$time1 = $_COOKIE['evtC'] - $_COOKIE['evtO']; // temps entre fin de saisie et ouverture de la page
							$time2 = $_COOKIE['evtH'] - $_COOKIE['evtO']; // temps entre click checkbox et ouverture de la page
							$time3 = $_COOKIE['evtV'] - $_COOKIE['evtH']; // temps entre validation formulaire et click checkbox
							$time4 = $_COOKIE['evtS'] - $_COOKIE['evtA']; // temps passé sur la checkbox
							if( $time1 >= 5000 && $time2 >= 1000 && $time3 >=300 && $time4 >=300 
								&& $this->getInput('formInputBlue')==='' ) $detectBot = 'human';
						}
						// Bot présumé
						if( $detectBot === 'bot') $_SESSION['humanBot']='bot';
					}
					// $_SESSION['humanBot']==='bot' ou option 'Pas de Captcha pour un humain' non validée
					elseif( md5($code) !== $_SESSION['captcha'] ) {
						$notice_captcha = $text['form']['index'][0];
					}
				}			
				// Mise à jour du brouillon
				foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $index => $tabval){
					switch ( $tabval['type']){
						case self::TYPE_MAIL:
							$_SESSION[$this->getUrl()]['draft']['mail'] = $this->getInput('formInput[' . $index . ']',helper::FILTER_MAIL);
							break;
						case self::TYPE_TEXTAREA:
							if(  $this->getInput('formInput[' . $index . ']',helper::FILTER_STRING_LONG_NOSTRIP) !== "")
							$_SESSION[$this->getUrl()]['draft']['textarea'][$index] = $this->getInput('formInput[' . $index . ']',helper::FILTER_STRING_LONG_NOSTRIP);
							break;
						case self::TYPE_CHECKBOX:
							$_SESSION[$this->getUrl()]['draft']['checkbox'][$index] = $this->getInput('formInput[' . $index . ']',helper::FILTER_BOOLEAN);
							break;
						case self::TYPE_SELECT:
							$_SESSION[$this->getUrl()]['draft']['select'][$index] = $this->getInput('formInput[' . $index . ']');
							break;
						case self::TYPE_SELECT_MUL:
							$value ="";
							if(isset($_POST["formInput_".$index])){
								foreach( $_POST["formInput_".$index] as $key => $val){
									$value .= $val.',';
								}
								$value = substr($value, 0 , strlen($value) - 1);
							}
							$_SESSION[$this->getUrl()]['draft']['selectMultiple'][$index] = $value;
							break;
						case self::TYPE_TEXT:
							$_SESSION[$this->getUrl()]['draft']['text'][$index] = $this->getInput('formInput[' . $index . ']');
							break;
						default:
							$filter = helper::FILTER_STRING_SHORT;						
					}
				}
				
				// Préparation du contenu du mail et des data
				$data = [];
				$content = '';
				$file_name = '';			
				foreach($this->getData(['module', $this->getUrl(0), 'input']) as $index => $input) {
					$filter = helper::FILTER_STRING_SHORT;
					if( $input['type'] === 'textarea') $filter = helper::FILTER_STRING_LONG;
					
					// Cas particuliers de la sélection multiple
					$value ="";
					$liaison = $text['form']['index'][13];
					if( $input['type'] === 'selectMultiple' && isset($_POST["formInput_".$index])){
						foreach( $_POST["formInput_".$index] as $key => $val){
							$value .= $val.$liaison;
						}
						// Suppression de la dernière liaison
						$value = substr($value, 0 , strlen($value) - strlen($liaison));
					} elseif( $input['type'] === 'checkbox' && null !== $this->getInput('formInput[' . $index . ']')){
					// Cas de la checkbox
						if($this->getInput('formInput[' . $index . ']') === "1") {$value = "1";} else {$value ="0";}					
					} else {
					// Cas général
						$value = $this->getInput('formInput[' . $index . ']', $filter, $input['required']) === true ? 'X' : $this->getInput('formInput[' . $index . ']', $filter, $input['required']);
					}
										
					// Préparation des données pour la création dans la base
					$data[$this->getData(['module', $this->getUrl(0), 'input', $index, 'id'])] = $value;
					// Préparation des données pour le mail
					$name_mail = $this->getData(['module', $this->getUrl(0), 'input', $index, 'name']);
					if( $name_mail === "" ) $name_mail = $text['form_view']['index'][7];
					if( $value !== '') $content .= '<strong>' . $name_mail. ' :</strong> ' . $value . '<br>';
					
				}
				
				if( $detectBot === 'bot') $notice_captcha = $text['form']['index'][12];
				
				$sent = true;
				if( $notice_captcha === ''){
					// Crée les données (Pas d'enregistrement lorsqu'une notice est présente)					
					$this->setData(['data_module', $this->getUrl(0), 'data', helper::increment(1, $this->getData(['data_module', $this->getUrl(0), 'data'])), $data]);
					// Emission du mail
					// Rechercher l'adresse en fonction du mail
					$singleuser = $this->getData(['user', $this->getData(['module', $this->getUrl(0), 'config', 'user']), 'mail']);
					$singlemail = $this->getData(['module', $this->getUrl(0), 'config', 'mail']);
					$group = $this->getData(['module', $this->getUrl(0), 'config', 'group']);
					// Verification si le mail peut être envoyé
					if(	self::$inputNotices === [] && ($group > 0 || $singleuser !== '' ||	$singlemail !== '' )) {
						// Utilisateurs dans le groupe
						$to = [];
						if ($group > 0){
							foreach($this->getData(['user']) as $userId => $user) {
								if($user['group'] >= $group) {
									$to[] = $user['mail'];
								}
							}
						}
						// Utilisateur désigné
						if (!empty($singleuser)) {
							$to[] = $singleuser;
						}
						// Mail désigné
						if (!empty($singlemail)) {
							$to[] = $singlemail;
						}
						if($to) {
							// Sujet du mail
							$subject = $this->getData(['module', $this->getUrl(0), 'config', 'subject']);
							if($subject === '') {
								$subject = $text['form']['index'][1];
							}
							// Envoi le mail
							$sent = $this->sendMail(
								$to,
								$subject,
								$text['form']['index'][2] . $this->getData(['page', $this->getUrl(0), 'title']) . '" :<br><br>' .
								$content
							);
						}
					}

					// Redirection
					$redirect = helper::baseUrl() . $this->getUrl(0);
					if ( $this->getData(['module', $this->getUrl(0), 'config', 'pageId']) !== '') $redirect = helper::baseUrl() . $this->getData(['module', $this->getUrl(0), 'config', 'pageId']);
					// Pas de $notice_captcha et si pas de notice pour les inputs
					if( self::$inputNotices === [] ){
						// Effacement des données provisoires
						$_SESSION[$this->getUrl()]['draft'] = [];
						$_SESSION[$this->getUrl()]['draft']['mail'] = "";
						$_SESSION[$this->getUrl()]['draft']['textarea'] = [];
						$_SESSION[$this->getUrl()]['draft']['checkbox'] = [];
						$_SESSION[$this->getUrl()]['draft']['select'] = [];
						$_SESSION[$this->getUrl()]['draft']['text'] = [];
						// Ce sondage a été validé dans cette session
						$_SESSION[$this->getUrl()][self::$i18n]['sondage_done'] = true;
					}
				} else {
					$sent = false;	
				}
					
				// Valeurs en sortie $sent false si $notice_captcha ou problème sur l'envoi du mail
				if( $sent !== true) {
					$_SESSION['humanBot']='bot';
					$redirect = helper::baseUrl() . $this->getUrl(0);
				}
				$this->addOutput([
					// la notification due aux entrées est prioritaire par rapport à celle due au captcha déclarée ici
					'notification' => ($sent === true ? $text['form']['index'][3] : $notice_captcha),
					'redirect' => $redirect,
					'state' => ($sent === true ? true : false),
					'vendor' => [
						'flatpickr',
						'tinymce'
					]
				]);
			}
		}
		
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index',
			'vendor' => [
				'flatpickr',
				'tinymce'
			],
		]);
	}
	
	/**
    * Crée un champ sélection à choix multiple
    * @param string $nameId Nom et id du champ
    * @param array $options Liste des options du champ de sélection ($value => $text)
    * @param array $attributes Attributs ($key => $value)
    * @return string
    */
    public static function selectMul($nameId, array $options, array $attributes = []) {
        // Attributs par défaut
        $attributes = array_merge([
            'before' => true,
            'class' => '',
            'classWrapper' => '',
            'noDirty' => false,
            'disabled' => false,
            'help' => '',
            'id' => $nameId,
            'label' => '',
            'name' => $nameId,
            'selected' => '',
			'selectMulIndex' => '',
            'fonts' => false,
			'font-size' => '',
			'ksort' => false,
			'url' => ''
        ], $attributes);
        // Sauvegarde des données en cas d'erreur
        if($attributes['before'] AND array_key_exists($attributes['id'], common::$inputBefore)) {
            $attributes['selected'] = common::$inputBefore[$attributes['id']];
        }

        // Début du wrapper
        $html = '<div id="' . $attributes['id'] . 'Wrapper" class="inputWrapper ' . $attributes['classWrapper'] . '">';
        // Label
        if($attributes['label']) {
            $html .= template::label($attributes['id'], $attributes['label'], [
                'help' => $attributes['help']
            ]);
        }
        // Notice
        $notice = '';
        if(array_key_exists($attributes['id'], common::$inputNotices)) {
            $notice = common::$inputNotices[$attributes['id']];
            $attributes['class'] .= ' notice';
        }
        $html .= template::notice($attributes['id'], $notice);
        // Début sélection / calcul hauteur
		$textSize = intval(substr($attributes['font-size'],0,2));
		$selectHeight = strval( (int) ( count($options) * ( ($textSize + 5) * 1.15 ) + 18 ) ).'px';
        $html .= sprintf('<select %s %s multiple>',
            helper::sprintAttributes($attributes),
			'style="height:'.$selectHeight.'"'
        );
		if( $attributes['ksort'] === true ) ksort($options);
        foreach($options as $value => $text) {
			if($value !== ""){
				$selected = '';
				if( isset($_SESSION[$attributes['url']]['draft']['selectMultiple'][$attributes['selectMulIndex']])) {	
					if( strpos($_SESSION[$attributes['url']]['draft']['selectMultiple'][$attributes['selectMulIndex']], $value) !== false ) $selected = ' selected';
				}
				$html .=   $attributes['fonts'] === true ? sprintf(
						'<option value="%s"%s style="font-family: %s;"> %s </option>',
						$value,
						$selected,
						$value,
						$text
					) : sprintf(
						'<option value="%s"%s>%s</option>',
							$value,
							$selected,
							$text
					);
			}
        }
        // Fin sélection
        $html .= '</select>';
        // Fin du wrapper
        $html .= '</div>';
        // Retourne le html
        return $html;
    }
}
