<?php
// Lexique
$param = 'form_view';
include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
?>
<div id="formConfigCopy" class="displayNone">
	<div class="formConfigInput">
		<?php echo template::hidden('formConfigPosition[]', [
			'class' => 'formConfigPosition'
		]); ?>
		<div class="row">
			<div class="col1">
				<?php echo template::button('formConfigMove[]', [
					'value' => template::ico('sort'),
					'class' => 'formConfigMove'
				]); ?>
			</div>
			<div class="col5">
				<?php echo template::text('formConfigName[]', [
					'placeholder' => $text['form_view']['config'][0]
				]); ?>
			</div>
			<div class="col4">
				<?php echo template::select('formConfigType[]', $types , [
					'class' => 'formConfigType',
					'ksort' => false
				]); ?>
			</div>
			<div class="col1">
				<?php echo template::button('formConfigMoreToggle[]', [
					'value' => template::ico('gear'),
					'class' => 'formConfigMoreToggle'
				]); ?>
			</div>
			<div class="col1">
				<?php echo template::button('formConfigDelete[]', [
					'value' => template::ico('minus'),
					'class' => 'formConfigDelete'
				]); ?>
			</div>
		</div>
		<div class="formConfigMoreLabel displayNone">
			<?php echo template::label('formConfigLabel', $text['form_view']['config'][1], [
					'class' => 'displayNone formConfigLabelWrapper'
				]); ?>
		</div>
		<div class="formConfigMore displayNone">
			<?php echo template::text('formConfigValues[]', [
				'placeholder' => $text['form_view']['config'][2],
				'class' => 'formConfigValues',
				'classWrapper' => 'displayNone formConfigValuesWrapper'
			]); ?>

			<?php $nbcara = [ '50'=>'50', '100'=>'100', '200'=>'200', '500'=>'500']; ?>
			<?php echo template::select('formConfigSelect[]', $nbcara , [
				'label' => $text['form_view']['config'][43],
				'class' => 'formConfigSelect',
				'classWrapper' => 'displayNone formConfigSelectWrapper',
				'selected' => $nbcara['50']
			]); ?>
			<?php echo template::checkbox('formConfigRichQuestion[]', true, $text['form_view']['config'][44], [
				'class' => 'formConfigRichQuestionWrapper',
				'help' => $text['form_view']['config'][45]
			]); ?>
			<?php echo template::checkbox('formConfigRequired[]', true, $text['form_view']['config'][3]); ?>
		</div>
	</div>
</div>
<?php echo template::formOpen('formConfigForm'); ?>
	<div class="row">
		<div class="col2">
			<?php echo template::button('formConfigBack', [
				'class' => 'buttonGrey',
				'href' => helper::baseUrl() . 'page/edit/' . $this->getUrl(0),
				'ico' => 'left',
				'value' => $text['form_view']['config'][4]
			]); ?>
		</div>
		<div class="col2">
			<?php echo template::button('formIndexHelp', [
				'class' => 'buttonHelp',
				'ico' => 'help',
				'value' => $text['form_view']['config'][39]
			]); ?>
		</div>
		<div class="col2 offset2" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?>>
			<?php echo template::button('formConfigData', [
				'href' => helper::baseUrl() . $this->getUrl(0) . '/question',
				'value' => $text['form_view']['config'][47]
			]); ?>
		</div>
		<div class="col2" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?>>
			<?php echo template::button('formConfigData', [
				'href' => helper::baseUrl() . $this->getUrl(0) . '/data',
				'value' => $text['form_view']['config'][5]
			]); ?>
		</div>
		<div class="col2 <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo 'offset8'; ?>">
			<?php echo template::submit('formConfigSubmit',[
				'value' => $text['form_view']['config'][30]
			]); ?>
		</div>
	</div>
	<!-- Aide à propos de la configuration de formulaire, view config -->
	<div class="helpDisplayContent">
		<?php echo file_get_contents( $text['form_view']['config'][40]) ;?>
	</div>
	<div class="row">
		<div class="col12">
			<div class="block">
				<div class="blockTitle"><?php echo $text['form_view']['config'][6]; ?></div>
				<?php echo template::text('formConfigButton', [
					'help' => $text['form_view']['config'][7],
					'label' => $text['form_view']['config'][8],
					'value' => $this->getData(['module', $this->getUrl(0), 'config', 'button'])
				]); ?>
				<div <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?> >
					<?php echo template::checkbox('formConfigMailOptionsToggle', true, $text['form_view']['config'][9], [
						'checked' => (bool) $this->getData(['module', $this->getUrl(0), 'config', 'group']) ||
											!empty($this->getData(['module', $this->getUrl(0), 'config', 'user'])) ||
											!empty($this->getData(['module', $this->getUrl(0), 'config', 'mail'])),
						'help' => $text['form_view']['config'][10]
					]); ?>
					<div id="formConfigMailOptions" class="displayNone">
						<div class="row">
							<div class="col11 offset1">
								<?php echo template::text('formConfigSubject', [
									'help' => $text['form_view']['config'][11],
									'label' => $text['form_view']['config'][12],
									'value' => $this->getData(['module', $this->getUrl(0), 'config', 'subject'])
								]); ?>
							</div>
						</div>
						<?php
							// Element 0 quand aucun membre a été sélectionné
							$groupMembers = [''] + $groupNews;
						?>
						<div class="row">
							<div class="col3 offset1">
								<?php echo template::select('formConfigGroup', $groupMembers, [
									'label' => $text['form_view']['config'][13],
									'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'group']),
									'help' => $text['form_view']['config'][14]
								]); ?>
							</div>
							<div class="col3">
								<?php echo template::select('formConfigUser', $module::$listUsers, [
									'label' => $text['form_view']['config'][15],
									'selected' => array_search($this->getData(['module', $this->getUrl(0), 'config', 'user']),$module::$listUsers)
								]); ?>
							</div>
							<div class="col4">
								<?php echo template::text('formConfigMail', [
									'label' => $text['form_view']['config'][16],
									'value' => $this->getData(['module', $this->getUrl(0), 'config', 'mail']),
									'help' => $text['form_view']['config'][17]
								]); ?>
							</div>
						</div>
					</div>
				</div>
				<div class="row" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?> >
					<div class="col4">
						<?php echo template::select('formConfigSignature', $signature, [
							'label' => $text['form_view']['config'][20],
							'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'signature'])
						]); ?>
					</div>
					<div class="col4">
												<?php echo template::file('formConfigLogo', [
							'help' => $text['form_view']['config'][21],
														'label' => $text['form_view']['config'][22],
														'value' => $this->getData(['module', $this->getUrl(0), 'config', 'logoUrl'])
												]); ?>
					</div>
					<div class="col4">
						<?php echo template::select('formConfigLogoWidth', $module::$logoWidth, [
							'label' => $text['form_view']['config'][23],
							'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'logoWidth'])
						]); ?>
					</div>
				</div>
				<div class="row" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?>>
					<div class="col6">
						<?php echo template::checkbox('formConfigPageIdToggle', true, $text['form_view']['config'][24], [
							'checked' => (bool) $this->getData(['module', $this->getUrl(0), 'config', 'pageId'])
						]); ?>
					</div>
					<div class="col5">
						<?php echo template::select('formConfigPageId', $module::$pages, [
							'classWrapper' => 'displayNone',
							'label' => $text['form_view']['config'][25],
							'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'pageId'])
						]); ?>
					</div>
				</div>
				<div class="row" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?>>
					<div class="col4">
						<?php echo template::select('formConfigGroupStat', $groupNews, [
							'label' => $text['form_view']['config'][41],
							'selected' => $this->getData(['module', $this->getUrl(0), 'config', 'groupStat']),
							'help' => $text['form_view']['config'][42]
						]); ?>
					</div>
					<div class="col4">
						<?php echo template::checkbox('formConfigVisibleForm', true, $text['form_view']['config'][46], [
							'checked' => $this->getData(['module', $this->getUrl(0), 'config', 'visibleForm'])
						]); ?>
					</div>
				</div>
				<div class="row" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?> >
					<div class="col4">
						<?php echo template::checkbox('formConfigCaptcha', true, $text['form_view']['config'][26], [
							'checked' => $this->getData(['module', $this->getUrl(0), 'config', 'captcha'])
						]); ?>
					</div>
				</div>
			</div>
			<div class="block" <?php if($this->getUser('group') < self::GROUP_MODERATOR) echo '<div style="display: none;">'; ?>>
				<div class="blockTitle"><?php echo $text['form_view']['config'][27]; ?></div>
				<div id="formConfigNoInput">
					<?php echo template::speech($text['form_view']['config'][28]); ?>
				</div>
				<div id="formConfigInputs"></div>
				<div class="row">
					<div class="col1 offset11">
						<?php echo template::button('formConfigAdd', [
							'value' => template::ico('plus')
						]); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php echo template::formClose(); ?>
<div class="moduleVersion"><?php echo $text['form_view']['config'][29]; ?>
	<?php echo $module::VERSION; ?>
</div>
