<?php

/**
 * This file is part of DeltaCMS.
 * For full copyright and license information, please see the LICENSE
 * file that was distributed with this source code.
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2021, Sylvain Lelièvre
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 *
 * Delta was created from version 11.2.00.24 of ZwiiCMS
 * @author Rémi Jean <remi.jean@outlook.com>
 * @copyright Copyright (C) 2008-2018, Rémi Jean
 * @author Frédéric Tempez <frederic.tempez@outlook.com>
 * @copyright Copyright (C) 2018-2021, Frédéric Tempez
 */
 
class sondage extends common {

	const VERSION = '2.5';
	const REALNAME = 'Sondage';
	const DELETE = true;
	const UPDATE = '0.0';
	//const DATADIRECTORY = ''; // Contenu localisé inclus par défaut (page.json et module.json)
	
	

	public static $actions = [
		'config' => self::GROUP_EDITOR,
		'update' => self::GROUP_EDITOR,
		'data' => self::GROUP_MODERATOR,
		'question' => self::GROUP_MODERATOR,
		'delete' => self::GROUP_MODERATOR,
		'deleteall' => self::GROUP_MODERATOR,
		'index' => self::GROUP_VISITOR,
		'export2csv' => self::GROUP_MODERATOR,
		'selectMul' => self::GROUP_VISITOR,
		'setDataModule' => self::GROUP_EDITOR,
		'deleteDataModule' => self::GROUP_MODERATOR,
		'getDataModule' => self::GROUP_VISITOR,
		'surveyValidation' => self::GROUP_VISITOR,
		'texts' => self::GROUP_MODERATOR,
	];

	public static $data = [];

	public static $pages = [];

	public static $pagination;
	
	public static $messageValidation;

	// Objets
	const TYPE_MAIL = 'mail';
	const TYPE_SELECT = 'select';
	const TYPE_SELECT_MUL = 'selectMultiple';
	const TYPE_TEXT = 'text';
	const TYPE_TEXTAREA = 'textarea';
	const TYPE_CHECKBOX = 'checkbox';
	const TYPE_LABEL = 'label';
	const ITEMSPAGE = 10;

	public static $listUsers = [
	];
	
	public static $logoWidth = [
		'40' => '40%',
		'60' => '60%',
		'80' => '80%',
		'100' => '100%'
	];
	
	/**
	 * Mise à jour ou initialisation du module
	 */
	private function update() {
		// Initialisation
		if ( null=== $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
			$this->init();	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			if( version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '2.2', '<') ){
				$this->setData(['module', $this->getUrl(0),'texts',
					[
						'send' => $this->getData(['module', $this->getUrl(0), 'config', 'button']) ? $this->getData(['module', $this->getUrl(0), 'config', 'button']) : $text['form_view']['index'][0],
						'noFields' => $text['form_view']['index'][1],
						'checked' => $text['form_view']['index'][3],
						'noChecked' => $text['form_view']['index'][4],
						'numberResponses' => $text['form_view']['index'][5],
						'results' => $text['form_view']['index'][6],
						'headingMissing' => $text['form_view']['index'][7],
						'wrongCaptcha' => $text['form']['index'][0],
						'formSubmitted' => $text['form']['index'][3],
						'fillCaptcha' => $text['form']['index'][12],
						'alreadyAnswered' => $text['form']['index'][14],
						'mailAlreadyAnswered' => $text['form']['index'][15],
						'mailLinkClick' => $text['form']['index'][16],
						'mailAlreadyUsed' => $text['form']['index'][17],
						'youMustValidate' => $text['form']['surveyValidation'][0],
						'alreadyValidated' => $text['form']['surveyValidation'][1],
						'timeExpired' => $text['form']['surveyValidation'][2],
						'validated' => $text['form']['surveyValidation'][3],
						'linkNotActive' => $text['form']['surveyValidation'][4],
						'alreadyResponded' => $text['form']['surveyValidation'][5]				
					]
				]);		
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', '2.2']);
			}
			if( version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '2.4', '<') ){
				if(is_file('./module/sondage/view/index/index.css')) unlink('./module/sondage/view/index/index.css');
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', '2.4']);
			}
			if( version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '2.5', '<') ){
				$this->setData(['module', $this->getUrl(0), 'config', 'signature', 'text']);
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', '2.5']);
			}
		}
	}
	
	/**
	 * Initialisation
	 */
	private function init(){
		// Lexique
		$param = '';
		include('./module/sondage/lang/'. helper::lexlang($this->getData(['config', 'i18n', 'langBase']) , $this->getData(['config', 'i18n', 'langAdmin'])) . '/lex_form.php');
		$this->setData(['module', $this->getUrl(0),'texts',
			[
				'send' => $text['form_view']['index'][0],
				'noFields' => $text['form_view']['index'][1],
				'checked' => $text['form_view']['index'][3],
				'noChecked' => $text['form_view']['index'][4],
				'numberResponses' => $text['form_view']['index'][5],
				'results' => $text['form_view']['index'][6],
				'headingMissing' => $text['form_view']['index'][7],
				'wrongCaptcha' => $text['form']['index'][0],
				'formSubmitted' => $text['form']['index'][3],
				'fillCaptcha' => $text['form']['index'][12],
				'alreadyAnswered' => $text['form']['index'][14],
				'mailAlreadyAnswered' => $text['form']['index'][15],
				'mailLinkClick' => $text['form']['index'][16],
				'mailAlreadyUsed' => $text['form']['index'][17],
				'youMustValidate' => $text['form']['surveyValidation'][0],
				'alreadyValidated' => $text['form']['surveyValidation'][1],
				'timeExpired' => $text['form']['surveyValidation'][2],
				'validated' => $text['form']['surveyValidation'][3],
				'linkNotActive' => $text['form']['surveyValidation'][4],
				'alreadyResponded' => $text['form']['surveyValidation'][5]
			]
		]);
		$this->setData(['module', $this->getUrl(0), 'config',
			[
				'button' => "",
				'captcha' => true,
				'group' => 0,
				'user' =>  "",
				'mail' => "",
				'pageId' => "",
				'subject' => "",
				'signature' => 'text',
				'logoUrl' => "",
				'logoWidth' => "40",
				'versionData' => self::VERSION,
				'groupStat' => 0,
				'visibleForm' => false,
				'validation' => false,
				'rgpdCheck' => false
			]
		]);
	}

	/**
	 * Configuration
	 */
	public function config() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['config'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Liste des utilisateurs
			$userIdsFirstnames = helper::arrayCollumn($this->getData(['user']), 'firstname');
			ksort($userIdsFirstnames);
			self::$listUsers [] = '';
			foreach($userIdsFirstnames as $userId => $userFirstname) {
				self::$listUsers [] =  $userId;
			}
			// Soumission du formulaire
			if($this->isPost()) {
				// Configuration
				$this->setData([
					'module',
					$this->getUrl(0),
					'config',
					[
						'button' => $this->getInput('formConfigButton'),
						'captcha' => $this->getInput('formConfigCaptcha', helper::FILTER_BOOLEAN),
						'group' => $this->getInput('formConfigGroup', helper::FILTER_INT),
						'user' =>  self::$listUsers [$this->getInput('formConfigUser', helper::FILTER_INT)],
						'mail' => $this->getInput('formConfigMail') ,
						'pageId' => $this->getInput('formConfigPageIdToggle', helper::FILTER_BOOLEAN) === true ? $this->getInput('formConfigPageId', helper::FILTER_ID) : '',
						'subject' => $this->getInput('formConfigSubject'),
						'signature' => $this->getInput('formConfigSignature'),
						'logoUrl' => $this->getInput('formConfigLogo'),
						'logoWidth' => $this->getInput('formConfigLogoWidth'),
						'versionData' => self::VERSION,
						'groupStat' => $this->getInput('formConfigGroupStat', helper::FILTER_INT),
						'visibleForm' => $this->getInput('formConfigVisibleForm', helper::FILTER_BOOLEAN),
						'validation' => $this->getInput('formConfigValidation', helper::FILTER_BOOLEAN),
						'rgpdCheck' => $this->getInput('formConfigRgpdCheck', helper::FILTER_BOOLEAN)
					]
				]);
				// Génération des données vides
				if ($this->getData(['data_module', $this->getUrl(0), 'data']) === null) {
					$this->setData(['data_module', $this->getUrl(0), 'data', []]);
				}
				// Génération des champs
				$inputs = [];
				foreach($this->getInput('formConfigPosition', null) as $index => $position) {
					// Si l'id n'existe pas on le crée
					if( null !== $this->getData(['module', $this->getUrl(0), 'input', $index , 'id']) ){
						$ident = $this->getData(['module', $this->getUrl(0), 'input', $index, 'id']);
					} else {
						$ident = rand(1000000,9999999);
					}
					// suppression des espaces avant ou après les virgules dans les values
					$values_ok = $this->getInput('formConfigValues[' . $index . ']');
					$values_ok = preg_replace('/\s*,\s*/', ',', trim($values_ok));
					// suppression d'une virgule terminale dans les values
					if( substr($values_ok, -1) === ',') $values_ok = substr($values_ok,0,-1);
					$inputs[] = [
						'id' => $ident,
						'name' => htmlspecialchars_decode($this->getInput('formConfigName[' . $index . ']'),ENT_QUOTES),
						'position' => helper::filter($position, helper::FILTER_INT),
						'required' => $this->getInput('formConfigRequired[' . $index . ']', helper::FILTER_BOOLEAN),
						'type' => $this->getInput('formConfigType[' . $index . ']'),
						'values' => $values_ok,
						'nbcara' => $this->getInput('formConfigSelect[' . $index . ']'),
						'richquestion' => $this->getInput('formConfigRichQuestion[' . $index . ']', helper::FILTER_BOOLEAN)
					];
				}
				$this->setData(['module', $this->getUrl(0), 'input', $inputs]);
				// Valeurs en sortie
				$this->addOutput([
					'notification' => $text['form']['config'][0],
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'state' => true
				]);
			}
			// Liste des pages
			foreach($this->getHierarchy(null, false) as $parentPageId => $childrenPageIds) {
				self::$pages[$parentPageId] = $this->getData(['page', $parentPageId, 'title']);
				foreach($childrenPageIds as $childKey) {
					self::$pages[$childKey] = '&nbsp;&nbsp;&nbsp;&nbsp;' . $this->getData(['page', $childKey, 'title']);
				}
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['config'][1],
				'vendor' => [
					'html-sortable',
					'flatpickr'
				],
				'view' => 'config'
			]);
		}
	}

	/**
	 * Textes pour internationalisation
	 */
	public function texts() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['texts'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Soumission du formulaire
			if($this->isPost()) {
				$this->setData(['module', $this->getUrl(0), 'texts',[
					'send' => $this->getInput('formTextsButton', helper::FILTER_STRING_SHORT),
					'noFields' => $this->getInput('formTextsNoFields', helper::FILTER_STRING_SHORT),
					'checked' => $this->getInput('formTextsChecked', helper::FILTER_STRING_SHORT),
					'noChecked' => $this->getInput('formTextsNoChecked', helper::FILTER_STRING_SHORT),
					'numberResponses' => $this->getInput('formTextsNumberResponses', helper::FILTER_STRING_SHORT),
					'results' => $this->getInput('formTextsResults', helper::FILTER_STRING_SHORT),
					'headingMissing' => $this->getInput('formTextsHeadingMissing', helper::FILTER_STRING_SHORT),
					'wrongCaptcha' => $this->getInput('formTextsWrongCaptcha', helper::FILTER_STRING_SHORT),
					'formSubmitted' => $this->getInput('formTextsFormSubmitted', helper::FILTER_STRING_SHORT),
					'fillCaptcha' => $this->getInput('formTextsFillCaptcha', helper::FILTER_STRING_SHORT),
					'alreadyAnswered' => $this->getInput('formTextsAlreadyAnswered', helper::FILTER_STRING_SHORT),
					'mailAlreadyAnswered' => $this->getInput('formTextsMailAlreadyAnswered', helper::FILTER_STRING_SHORT),
					'mailLinkClick' => $this->getInput('formTextsMailLinkClick', helper::FILTER_STRING_SHORT),
					'mailAlreadyUsed' => $this->getInput('formTextsMailAlreadyUsed', helper::FILTER_STRING_SHORT),
					'youMustValidate' => $this->getInput('formTextsYouMustValidate', helper::FILTER_STRING_SHORT),
					'alreadyValidated' => $this->getInput('formTextsAlreadyValidated', helper::FILTER_STRING_SHORT),
					'timeExpired' => $this->getInput('formTextsTimeExpired', helper::FILTER_STRING_SHORT),
					'validated' => $this->getInput('formTextsValidated', helper::FILTER_STRING_SHORT),
					'linkNotActive' => $this->getInput('formTextsLinkNotActive', helper::FILTER_STRING_SHORT),
					'alreadyResponded' => $this->getInput('formTextsAlreadyResponded', helper::FILTER_STRING_SHORT)
				]]);
			
				$this->addOutput([
					'redirect' => helper::baseUrl() . $this->getUrl(0) . '/config',
					'notification' => $text['form']['texts'][1],
					'state' => true
				]);
				
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['texts'][0],
				'vendor' => [
					'html-sortable',
					'flatpickr'
				],
				'view' => 'texts'
			]);
		}
	}


	/**
	 * Données enregistrées
	 */
	public function data() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['data'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
			if($data) {
				// Pagination
				$pagination = helper::pagination($data, $this->getUrl(),self::ITEMSPAGE);
				// Liste des pages
				self::$pages = $pagination['pages'];
				// Inverse l'ordre du tableau
				$dataIds = array_reverse(array_keys($data));
				$data = array_reverse($data);
				// Données en fonction de la pagination
				for($i = $pagination['first']; $i < $pagination['last']; $i++) {
					$content = '';
					if( isset($data[$i]['validation']['done']) && $data[$i]['validation']['done'] === false ) $content .= '<span style="font-style: italic;">'.$text['form']['data'][1] . '</span><br>';
					foreach($data[$i] as $input => $value) {
						if( ! is_array($value)){
							// $input est un code présent dans 'data' et 'input' il faut afficher le 'name' correspondant de 'input'
							foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $key => $tabval ){
								if( $tabval['id'] === $input ) $name = $tabval['name'];
							}
							if( $name === "") $name = $text['form_view']['index'][7];
							$content .= $name . ' : ' . $value . '<br>';
						}
					}
					self::$data[] = [
						$content,
						template::button('formDataDelete' . $dataIds[$i], [
							'class' => 'formDataDelete buttonRed',
							'href' => helper::baseUrl() . $this->getUrl(0) . '/delete/' . $dataIds[$i]  . '/' . $_SESSION['csrf'],
							'value' => template::ico('cancel')
						])
					];
				}
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['data'][0],
				'view' => 'data'
			]);
		}
	}

	/**
	 * Rédaction des questions avec Tinymce
	 */
	public function question() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['question'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Soumission du formulaire
			if($this->isPost()) {
				// Enregistrement des questions
				foreach($this->getData(['module', $this->getUrl(0), 'input']) as $key => $input){
					if( $input['richquestion'] === true){
						$content = empty($this->getInput('formQuestion['. $key .']', null)) ? '<p></p>' : str_replace('<p></p>', '', $this->getInput('formQuestion['. $key .']', null));
						$this->setData(['module', $this->getUrl(0), 'question', $input['id'], $content ]);	
						
						
					}
				}
				// Valeurs en sortie
				$this->addOutput([
					'notification' => $text['form']['question'][1],
					'redirect' => helper::baseUrl() . $this->getUrl(),
					'state' => true
				]);
			}
			// Valeurs en sortie
			$this->addOutput([
				'title' => $text['form']['question'][0],
				'vendor' => ['tinymce'],
				'view' => 'question'
			]);		
		}
	}

	/**
	 * Export CSV
	 */
	public function export2csv() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['export2csv'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');	
			// Jeton incorrect
			if ($this->getUrl(2) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['export2csv'][0]
				]);
			} else {
				$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
				// Suppression des participations non validées et des données 'validation'
				foreach( $data as $id=>$value){
				  if( isset($value['validation']['done']) && $value['validation']['done'] === false){
					unset( $data[$id]);
				  }
				}
				foreach( $data as $id=>$value){
				  if( isset($value['validation'])){
					unset( $data[$id]['validation']);
				  }
				}
				if ($data !== []) {
					$csvfilename = 'data-'.date('dmY').'-'.date('Hi').'-'.rand(10,99).'.csv';
					if (!file_exists(self::FILE_DIR.'source/data')) {
						mkdir(self::FILE_DIR.'source/data', 0755);
					}
					$fp = fopen(self::FILE_DIR.'source/data/'.$csvfilename, 'w');
					// Récupérer les bonnes clefs
					foreach($data as $key=>$value){
						$tabdata = array_keys($data[$key]);
						break;
					}
					// $input est un code présent dans 'data' et 'input' il faut afficher le 'name' correspondant de 'input'
					foreach( $tabdata as $key1 => $val){
						foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $key2 => $tabval ){
							if( $tabval['id'] === $val ) $tabdata[$key1] = $tabval['name'];
						}	
					}
					fputcsv($fp, $tabdata , ';','"');
					foreach ($data as $fields) {
						fputcsv($fp, $fields, ';','"');
					}
					fclose($fp);
					// Valeurs en sortie
					$this->addOutput([
						'notification' => $text['form']['export2csv'][1].$csvfilename,
						'redirect' => helper::baseUrl() . $this->getUrl(0) .'/data',
						'state' => true
					]);
				} else {
					$this->addOutput([
						'notification' => $text['form']['export2csv'][2],
						'redirect' => helper::baseUrl() . $this->getUrl(0) .'/data'
					]);
				}
			}
		}
	}


	/**
	 * Suppression
	 */
	public function deleteall() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['deleteall'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Jeton incorrect
			if ($this->getUrl(2) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['deleteall'][0]
				]);
			} else {
				$data = $this->getData(['data_module', $this->getUrl(0), 'data']);
				if (count($data) > 0 ) {
					// Suppression multiple
					$this->setData(['data_module', $this->getUrl(0), 'data', [] ]);
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['deleteall'][1],
						'state' => true
					]);
				} else {
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['deleteall'][2]
					]);
				}
			}
		}
	}


	/**
	 * Suppression
	 */
	public function delete() {
		// Autorisation 
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < sondage::$actions['delete'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			$param = '';
			include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
			// Jeton incorrect
			if ($this->getUrl(3) !== $_SESSION['csrf']) {
				// Valeurs en sortie
				$this->addOutput([
					'redirect' => helper::baseUrl()  . $this->getUrl(0) . '/data',
					'notification' => $text['form']['delete'][0]
				]);
			} else {
				// La donnée n'existe pas
				if($this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2)]) === null) {
					// Valeurs en sortie
					$this->addOutput([
						'access' => false
					]);
				}
				// Suppression
				else {
					$this->deleteData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2)]);					
					// Valeurs en sortie
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(0) . '/data',
						'notification' => $text['form']['delete'][1],
						'state' => true
					]);
				}
			}
		}
	}

	/**
	 *
	 * Validation d'une participation au sondage par retour de courriel
	 */
	public function surveyValidation(){
		// Lexique
		$param = '';
		include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
		// Message avant ou après validation
		if( null !== $this->getUrl(2) ){
			// Traitement pour validation de la participation : participation validée ou temps dépassé ou participation déjà validée ou courriel déjà utilisé
			if( null !== $this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2), 'validation' ]) ){
				$dataval = $this->getData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2), 'validation' ]);
				if($dataval['done']===true){
					self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'alreadyValidated']);
				} else {
					// contrôle de l'id
					if( $dataval['id'] !== $this->getUrl(3) ){
						self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'linkNotActive']);
					} else {
						// contrôle du timeout
						if( time() > ($dataval['time'] + 30*60) ){
							self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'timeExpired']);
						} else {
							// contrôle que l'adresse courriel n'a pas été utilisée pour une participation validée
							$countmail=0;
							foreach( $this->getData(['data_module', $this->getUrl(0), 'data' ]) as $id => $val){
								if( isset($val['validation']['mail']) && $val['validation']['mail'] === $dataval['mail'] && isset($val['validation']['done']) && $val['validation']['done'] === true) $countmail++;
							}
							if( $countmail > 0 ){
								self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'alreadyResponded']);
							} else {
								// validation de la participation
								$this->setData(['data_module', $this->getUrl(0), 'data', $this->getUrl(2), 'validation', 'done', true ]);
								self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'validated']);
							}
						}
					}
				}
			} else {
				// Lien non actif
				self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'linkNotActive']);
			}
		} else {
			// Message d'invite à valider la participation
			self::$messageValidation = $this->getData(['module', $this->getUrl(0),'texts', 'youMustValidate']);
		}
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => false,
			'view' => 'validation'
		]);	
	}


	/**
	 * Accueil
	 */
	public function index() {
		// Mise à jour du module
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) || version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<') ) $this->update();	
		// Lexique
		$param = '';
		$detectBot ='';
		include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');
		// Création du brouillon s'il n'existe pas
		if( !isset($_SESSION[$this->getUrl()]['draft'])){
			$_SESSION[$this->getUrl()]['draft'] = [];
			$_SESSION[$this->getUrl()]['draft']['mail'] = "";
			$_SESSION[$this->getUrl()]['draft']['textarea'] = [];
			$_SESSION[$this->getUrl()]['draft']['checkbox'] = [];
			$_SESSION[$this->getUrl()]['draft']['select'] = [];
			$_SESSION[$this->getUrl()]['draft']['selectMultiple'] = [];
			$_SESSION[$this->getUrl()]['draft']['text'] = [];			
		}
		// Soumission du formulaire
		if($this->isPost()) {
			// réponse validée par email à ce questionnaire déjà enregistrée ?
			$countmail=0;
			$datamail='';
			// $datamail : première adresse courriel saisie
			foreach($this->getData(['module', $this->getUrl(0), 'input']) as $index => $input) {
				if( $input['type'] === 'mail' ){
					$datamail = $this->getInput('formInput[' . $index . ']');
					break;
				}
			}

			foreach( $this->getData(['data_module', $this->getUrl(0), 'data' ]) as $id => $val){
				if( isset($val['validation']['mail']) && $val['validation']['mail'] === $datamail && isset($val['validation']['done']) && $val['validation']['done'] === true) $countmail++;
			}
			if(	$this->getData(['module', $this->getUrl(0), 'config', 'validation']) && $countmail > 0){
				$this->addOutput([
					'notification' => $this->getData(['module', $this->getUrl(0),'texts', 'mailAlreadyUsed']),
					'redirect' => helper::baseUrl() . $this->getUrl(0),
					'state' => false,
					'vendor' => [
						'flatpickr',
						'tinymce'
					]
				]);	
			// réponse valide à ce questionnaire, dans cette langue, déjà enregistrée pour cette session
			} elseif( isset($_SESSION[$this->getUrl()][self::$i18n]['sondage_done']) && $_SESSION[$this->getUrl()][self::$i18n]['sondage_done']=== true ){
				$this->addOutput([
					'notification' => $this->getData(['module', $this->getUrl(0),'texts', 'alreadyAnswered']),
					'redirect' => helper::baseUrl() . $this->getUrl(0),
					'state' => false,
					'vendor' => [
						'flatpickr',
						'tinymce'
					]
				]);		
			} else {
				$notice_captcha = '';
				$code = isset($_REQUEST['codeCaptcha'] ) ? strtoupper($_REQUEST['codeCaptcha']) : '';
				// Captcha demandée
				if(	$this->getData(['module', $this->getUrl(0), 'config', 'captcha'])){
					// option de détection de robot en premier cochée et $_SESSION['humanBot']==='human'
					if(	$_SESSION['humanBot']==='human' && $this->getData(['config', 'connect', 'captchaBot'])=== true ) {
						// Présence des 6 cookies et checkbox cochée ?
						$detectBot ='bot';
						if ( isset ($_COOKIE['evtC']) && isset ($_COOKIE['evtO']) && isset ($_COOKIE['evtV']) && isset ($_COOKIE['evtH']) 
							&& isset ($_COOKIE['evtS']) && isset ($_COOKIE['evtA']) && $this->getInput('formHumanCheck', helper::FILTER_BOOLEAN) === true ) {
							// Calcul des intervals de temps
							$time1 = $_COOKIE['evtC'] - $_COOKIE['evtO']; // temps entre fin de saisie et ouverture de la page
							$time2 = $_COOKIE['evtH'] - $_COOKIE['evtO']; // temps entre click checkbox et ouverture de la page
							$time3 = $_COOKIE['evtV'] - $_COOKIE['evtH']; // temps entre validation formulaire et click checkbox
							$time4 = $_COOKIE['evtS'] - $_COOKIE['evtA']; // temps passé sur la checkbox
							if( $time1 >= 5000 && $time2 >= 1000 && $time3 >=300 && $time4 >=300 
								&& $this->getInput('formInputBlue')==='' ) $detectBot = 'human';
						}
						// Bot présumé
						if( $detectBot === 'bot') $_SESSION['humanBot']='bot';
					}
					// $_SESSION['humanBot']==='bot' ou option 'Pas de Captcha pour un humain' non validée
					elseif( md5($code) !== $_SESSION['captcha'] ) {
						$notice_captcha = $this->getData(['module', $this->getUrl(0),'texts', 'wrongCaptcha']);
					}
				}			
				// Mise à jour du brouillon
				foreach( $this->getData(['module', $this->getUrl(0), 'input']) as $index => $tabval){
					switch ( $tabval['type']){
						case self::TYPE_MAIL:
							$_SESSION[$this->getUrl()]['draft']['mail'] = $this->getInput('formInput[' . $index . ']',helper::FILTER_MAIL);
							break;
						case self::TYPE_TEXTAREA:
							if(  $this->getInput('formInput[' . $index . ']',helper::FILTER_STRING_LONG) !== "")
							$_SESSION[$this->getUrl()]['draft']['textarea'][$index] = $this->getInput('formInput[' . $index . ']',helper::FILTER_STRING_LONG);
							break;
						case self::TYPE_CHECKBOX:
							$_SESSION[$this->getUrl()]['draft']['checkbox'][$index] = $this->getInput('formInput[' . $index . ']',helper::FILTER_BOOLEAN);
							break;
						case self::TYPE_SELECT:
							$_SESSION[$this->getUrl()]['draft']['select'][$index] = $this->getInput('formInput[' . $index . ']');
							break;
						case self::TYPE_SELECT_MUL:
							$value ="";
							if(isset($_POST["formInput_".$index])){
								foreach( $_POST["formInput_".$index] as $key => $val){
									$value .= $val.',';
								}
								$value = substr($value, 0 , strlen($value) - 1);
							}
							$_SESSION[$this->getUrl()]['draft']['selectMultiple'][$index] = $value;
							break;
						case self::TYPE_TEXT:
							$_SESSION[$this->getUrl()]['draft']['text'][$index] = $this->getInput('formInput[' . $index . ']');
							break;
						default:
							$filter = helper::FILTER_STRING_SHORT;						
					}
				}
	
				// Ajout d'une notice sur la case à cocher d'acceptation des conditions si elle est utilisée et non cochée 
				if(	$this->getData(['module', $this->getUrl(0), 'config', 'rgpdCheck'])) $rgpdCheckbox = $this->getInput('formRgpdCheck', helper::FILTER_BOOLEAN,true);
				
				// Préparation du contenu du mail et des data
				$data = [];
				$content = '';
				$file_name = '';
				$client_mail= '';
				foreach($this->getData(['module', $this->getUrl(0), 'input']) as $index => $input) {
					$filter = helper::FILTER_STRING_SHORT;
					if( $input['type'] === 'textarea') $filter = helper::FILTER_STRING_LONG;
					
					// Cas particuliers de la sélection multiple
					$value ="";
					$liaison = $text['form']['index'][13];
					if( $input['type'] === 'selectMultiple' && isset($_POST["formInput_".$index])){
						foreach( $_POST["formInput_".$index] as $key => $val){
							$value .= $val.$liaison;
						}
						// Suppression de la dernière liaison
						$value = substr($value, 0 , strlen($value) - strlen($liaison));
					} elseif( $input['type'] === 'checkbox' && null !== $this->getInput('formInput[' . $index . ']')){
					// Cas de la checkbox
						if($this->getInput('formInput[' . $index . ']') === "1") {$value = "1";} else {$value ="0";}					
					} else {
					// Cas général
						$value = $this->getInput('formInput[' . $index . ']', $filter, $input['required']) === true ? 'X' : $this->getInput('formInput[' . $index . ']', $filter, $input['required']);
					}
					// Mémorisation du mail client (premier mail du sondage)
					if( $input['type'] === 'mail' && $client_mail === '') $client_mail = $this->getInput('formInput[' . $index . ']');
										
					// Préparation des données pour la création dans la base
					$data[$this->getData(['module', $this->getUrl(0), 'input', $index, 'id'])] = $value;
					// Ajout des paramètres si validation par courriel
					if( $this->getData(['module', $this->getUrl(0), 'config', 'validation']) === true){
						$data['validation']['done'] = false;
						$data['validation']['time'] = time();
						$data['validation']['id'] = bin2hex(random_bytes(20));
						$data['validation']['mail'] = $client_mail;
					}
					// Préparation des données pour le mail
					$name_mail = $this->getData(['module', $this->getUrl(0), 'input', $index, 'name']);
					if( $name_mail === "" ) $name_mail = $text['form_view']['index'][7];
					if( $value !== '') $content .= '<strong>' . $name_mail. ' :</strong> ' . $value . '<br>';
					
				}
				
				if( $detectBot === 'bot') $notice_captcha = $this->getData(['module', $this->getUrl(0),'texts', 'fillCaptcha']);
				
				$sent = true;
				if( $notice_captcha === '' && common::$inputNotices === []){
					// Crée les données (Pas d'enregistrement lorsqu'une notice est présente)
					$newId = helper::increment(1, $this->getData(['data_module', $this->getUrl(0), 'data']));
					$this->setData(['data_module', $this->getUrl(0), 'data', $newId, $data]);
					// Emission du mail aux gestionnaires du sondage
					// Rechercher l'adresse en fonction du mail
					$singleuser = $this->getData(['user', $this->getData(['module', $this->getUrl(0), 'config', 'user']), 'mail']);
					$singlemail = $this->getData(['module', $this->getUrl(0), 'config', 'mail']);
					$group = $this->getData(['module', $this->getUrl(0), 'config', 'group']);
					// Verification si le mail peut être envoyé
					if(	self::$inputNotices === [] && ($group > 0 || $singleuser !== '' ||	$singlemail !== '' )) {
						// Utilisateurs dans le groupe
						$to = [];
						if ($group > 0){
							foreach($this->getData(['user']) as $userId => $user) {
								if($user['group'] >= $group) {
									$to[] = $user['mail'];
								}
							}
						}
						// Utilisateur désigné
						if (!empty($singleuser)) {
							$to[] = $singleuser;
						}
						// Mail désigné
						if (!empty($singlemail)) {
							$to[] = $singlemail;
						}
						if($to) {
							// Sujet du mail
							$subject = $this->getData(['module', $this->getUrl(0), 'config', 'subject']);
							if($subject === '') {
								$subject = $text['form']['index'][1];
							}
							// Envoi le mail
							$sent = $this->sendMail(
								$to,
								$subject,
								$text['form']['index'][2] . $this->getData(['page', $this->getUrl(0), 'title']) . '" :<br><br>' .
								$content
							);
						}
					}

					// Redirection
					$redirect = helper::baseUrl() . $this->getUrl(0);
					if ( $this->getData(['module', $this->getUrl(0), 'config', 'pageId']) !== '') $redirect = helper::baseUrl() . $this->getData(['module', $this->getUrl(0), 'config', 'pageId']);
					// Pas de $notice_captcha et si pas de notice pour les inputs
					if( self::$inputNotices === [] ){
						// Effacement des données provisoires
						$_SESSION[$this->getUrl()]['draft'] = [];
						$_SESSION[$this->getUrl()]['draft']['mail'] = "";
						$_SESSION[$this->getUrl()]['draft']['textarea'] = [];
						$_SESSION[$this->getUrl()]['draft']['checkbox'] = [];
						$_SESSION[$this->getUrl()]['draft']['select'] = [];
						$_SESSION[$this->getUrl()]['draft']['text'] = [];
						// Ce sondage a été validé dans cette session
						$_SESSION[$this->getUrl()][self::$i18n]['sondage_done'] = true;
					}
					
					// Si validation de la participation par courriel envoi d'un mail avec le lien de validation et redirection spéciale
					if($this->getData(['module', $this->getUrl(0), 'config', 'validation']) === true){
						// Envoi du courriel au participant
						$to = $client_mail;
						if($to) {
							// Sujet du mail
							$subject =  $this->getData(['module', $this->getUrl(0),'texts', 'mailAlreadyAnswered']) . helper::baseUrl(false);
							// Envoi le mail
							$sent = $this->sendMail(
								$to,
								$subject,
								$this->getData(['module', $this->getUrl(0),'texts', 'mailLinkClick']) . $this->getData(['page', $this->getUrl(0), 'title']) . ' : <br><br>' .
								'<a href="'.helper::baseUrl() . $this->getUrl(0).'/surveyValidation/'.$newId.'/'.$data['validation']['id'].'" title="">'. helper::baseUrl() . $this->getUrl(0).'/surveyValidation/'.$newId.'/'.$data['validation']['id'] .'</a>'
							);
						}
						// Redirection spéciale et prioritaire
						$redirect = helper::baseUrl() . $this->getUrl(0).'/surveyValidation';
					}
					
				} else {
					$sent = false;	
				}
					
				// Valeurs en sortie $sent false si $notice_captcha ou problème sur l'envoi du mail
				if( $sent !== true) {
					$_SESSION['humanBot']='bot';
					$redirect = helper::baseUrl() . $this->getUrl(0);
				}
				$this->addOutput([
					// la notification due aux entrées est prioritaire par rapport à celle due au captcha déclarée ici
					'notification' => ($sent === true ? $this->getData(['module', $this->getUrl(0),'texts', 'formSubmitted']) : $notice_captcha),
					'redirect' => $redirect,
					'state' => ($sent === true ? true : false),
					'vendor' => [
						'flatpickr',
						'tinymce'
					]
				]);

			}
		}
		
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index',
			'vendor' => [
				'flatpickr',
				'tinymce'
			],
		]);
	}
	
	/**
    * Crée un champ sélection à choix multiple
    * @param string $nameId Nom et id du champ
    * @param array $options Liste des options du champ de sélection ($value => $text)
    * @param array $attributes Attributs ($key => $value)
    * @return string
    */
    public static function selectMul($nameId, array $options, array $attributes = []) {
        // Attributs par défaut
        $attributes = array_merge([
            'before' => true,
            'class' => '',
            'classWrapper' => '',
            'noDirty' => false,
            'disabled' => false,
            'help' => '',
            'id' => $nameId,
            'label' => '',
            'name' => $nameId,
            'selected' => '',
			'data-selectMulIndex' => '',
            'fonts' => false,
			'data-font-size' => '',
			'ksort' => false,
			'data-url' => ''
        ], $attributes);
        // Sauvegarde des données en cas d'erreur
        if($attributes['before'] AND array_key_exists($attributes['id'], common::$inputBefore)) {
            $attributes['selected'] = common::$inputBefore[$attributes['id']];
        }

        // Début du wrapper
        $html = '<div id="' . $attributes['id'] . 'Wrapper" class="inputWrapper ' . $attributes['classWrapper'] . '">';
        // Label
        if($attributes['label']) {
            $html .= template::label($attributes['id'], $attributes['label'], [
                'help' => $attributes['help']
            ]);
        }
        // Notice
        $notice = '';
        if(array_key_exists($attributes['id'], common::$inputNotices)) {
            $notice = common::$inputNotices[$attributes['id']];
            $attributes['class'] .= ' notice';
        }
        $html .= template::notice($attributes['id'], $notice);
        // Début sélection / calcul hauteur
		$textSize = intval(substr($attributes['data-font-size'],0,2));
		$selectHeight = strval( (int) ( count($options) * ( ($textSize + 5) * 1.15 ) + 18 ) ).'px';
        $html .= sprintf('<select %s %s multiple>',
            helper::sprintAttributes($attributes),
			'style="height:'.$selectHeight.'"'
        );
		if( $attributes['ksort'] === true ) ksort($options);
        foreach($options as $value => $text) {
			if($value !== ""){
				$selected = '';
				if( isset($_SESSION[$attributes['data-url']]['draft']['selectMultiple'][$attributes['data-selectMulIndex']])) {	
					if( strpos($_SESSION[$attributes['data-url']]['draft']['selectMultiple'][$attributes['data-selectMulIndex']], $value) !== false ) $selected = ' selected';
				}
				$html .=   $attributes['fonts'] === true ? sprintf(
						'<option value="%s"%s style="font-family: %s;"> %s </option>',
						$value,
						$selected,
						$value,
						$text
					) : sprintf(
						'<option value="%s"%s>%s</option>',
							$value,
							$selected,
							$text
					);
			}
        }
        // Fin sélection
        $html .= '</select>';
        // Fin du wrapper
        $html .= '</div>';
        // Retourne le html
        return $html;
    }
}
