<?php
// Lexique
$param = '';
include('./module/sondage/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_form.php');

// Flatpickr dans la langue en frontend si elle est connue de Flatpickr, y compris en traduction auto
$arrayFlatpickr = ['fr', 'es', 'pt', 'el', 'it'];
if( isset( $_SESSION['langFrontEnd'])){
	$lang_base = $_SESSION['langFrontEnd'];
} else {
	$lang_base = $this->getData(['config', 'i18n', 'langBase']);	
}
$lang_flatpickr = in_array($lang_base, $arrayFlatpickr) ? $lang_base : 'default';
?><script>var lang_flatpickr = "<?php echo $lang_flatpickr; ?>";</script> <?php

// Hauteur minimale de la zone d'édition de Tinymce ?>
<script> var tinyMiniHeight = 300; </script>

<?php // Adaptation de la langue dans tinymce pour la rédaction d'un message en fonction de la langue de la page, originale ou en traduction rédigée
$lang = $this->getData(['config', 'i18n', 'langBase']);
if ( !empty($_COOKIE["DELTA_I18N_SITE"])) {
	if( $this->getInput('DELTA_I18N_SITE') !== 'base' ) $lang = $this->getInput('DELTA_I18N_SITE');
}
$lang_page = $lang;
switch ($lang) {
	case 'en' :
		$lang_page = 'en_GB';
		break;
	case 'pt' :
		$lang_page = 'pt_PT';
		break;
	case 'sv' :
		$lang_page = 'sv_SE';
		break;
	case 'fr' :
		$lang_page = 'fr_FR';
		break;
}
// Si la langue n'est pas supportée par Tinymce la langue d'administration est utilisée
if( ! file_exists( 'core/vendor/tinymce/langs/'.$lang_page.'.js' )){
	$lang_page = $lang_admin;
}
echo '<script> var lang_admin = "'.$lang_page.'"; </script>';

if( null === $this->getData(['module', $this->getUrl(0), 'config', 'visibleForm'])  || $this->getData(['module', $this->getUrl(0), 'config', 'visibleForm']) === false){
	if($this->getData(['module', $this->getUrl(0), 'input'])): ?>
		<?php echo template::formOpenFile('formForm'); ?>
			<?php if($this->getData(['module', $this->getUrl(0), 'config', 'rgpdCheck' ]) === true){ ?>
			<div class="row">
				<div class="col12">
					<?php echo template::checkbox('formRgpdCheck', true, $this->getData(['locale', 'questionnaireAccept']), [
						'checked' => false
					]); ?>
				</div>
			</div>
			<?php } ?>
			<div class="humanBot">
			<?php $selectIndex=0; $textIndex=0;$checkboxIndex=0;
			foreach($this->getData(['module', $this->getUrl(0), 'input']) as $index => $input): ?>
				<?php if($input['richquestion'] === true){
					$label='';
					echo '<div>'. $this->getData(['module', $this->getUrl(0),'question', $input['id'] ]) . '</div>';	
				} else {
					$inputname = $input['name'] !== "" ? $input['name'] : $this->getData(['module', $this->getUrl(0),'texts', 'headingMissing' ]);
					$label = '<span class="blockTitle labelQuestion">'.$inputname.'</span>';
				} 
				// Label à droite des checkbox toujours affiché
					$labelCheckbox = $inputname;
				?>
				<?php if($input['type'] === $module::TYPE_MAIL): ?>
					<?php echo template::mail('formInput[' . $index . ']', [
						'id' => 'formInput_' . $index,
						'label' => $label,
						'value' => $_SESSION[$this->getUrl()]['draft']['mail']
					]); 
					echo '<br><br>'; ?>
				<?php elseif($input['type'] === $module::TYPE_SELECT): ?>
					<?php
					$values = array_flip(explode(',', $input['values']));
					foreach($values as $value => $key) {
						$values[$value] = $value;
					}
					?>
					<?php echo template::select('formInput[' . $index . ']', $values, [
						'id' => 'formInput_' . $index,
						'label' => $label,
						'selected' => isset($_SESSION[$this->getUrl()]['draft']['select'][$index]) ? $_SESSION[$this->getUrl()]['draft']['select'][$index] : ''
					]); 
					echo '<br><br>';
					$selectIndex++; ?>
				<?php elseif($input['type'] === $module::TYPE_SELECT_MUL): ?>
					<?php
					$values = array_flip(explode(',', $input['values']));
					foreach($values as $value => $key) {
						$values[$value] = trim($value);
					}
					?>
					<?php 
					$textSize = $this->getData(['theme', 'text','fontSize' ]);
					echo $module::selectMul('formInput_'. $index . '[]', $values, [
						'id' => 'formInput_' . $index,
						'name' => 'formInput_' . $index.'[]',
						'label' => $label,
						'data-selectMulIndex' => $index,
						'data-font-size' => $textSize,
						'data-url' => $this->getUrl()
					]); 
					echo '<br><br>'; ?>
				<?php elseif($input['type'] === $module::TYPE_TEXT): ?>
					<?php echo template::text('formInput[' . $index . ']', [
						'id' => 'formInput_' . $index,
						'label' => $label,
						'value' => isset($_SESSION[$this->getUrl()]['draft']['text'][$index]) ? $_SESSION[$this->getUrl()]['draft']['text'][$index] : ''
					]); 
					echo '<br><br>';
					$textIndex++; ?>
				<?php elseif($input['type'] === $module::TYPE_TEXTAREA): ?>
					<?php echo template::textarea('formInput[' . $index . ']', [
						'id' => 'formInput_' . $index,
						'label' => $label,
						'value' => isset($_SESSION[$this->getUrl()]['draft']['textarea'][$index]) ? $_SESSION[$this->getUrl()]['draft']['textarea'][$index] : '',
						'noDirty' => true,
						'maxlength' => $input['nbcara']
					]); 
					echo '<br><br>';?>
				<?php elseif($input['type'] === $module::TYPE_CHECKBOX): 
					if($input['richquestion'] === false) echo '<div class="blockTitle labelQuestion">';
					echo template::checkbox('formInput[' . $index . ']', true, $labelCheckbox, [
						'checked' => isset($_SESSION[$this->getUrl()]['draft']['checkbox'][$index]) ? $_SESSION[$this->getUrl()]['draft']['checkbox'][$index] : false	
					]); 
					if($input['richquestion'] === false) echo '</div>';
					echo '<br><br>';
					$checkboxIndex++; ?>	
				<?php elseif($input['type'] === $module::TYPE_LABEL): ?>
					<p class='formLabel'> <?php echo $label; ?> </p>
				<?php endif; ?>
					
			<?php endforeach; ?>
			</div>
			<?php if( $this->getData(['module', $this->getUrl(0), 'config', 'captcha']) ){
				
				if ( $_SESSION['humanBot']==='bot' || $this->getData(['config', 'connect', 'captchaBot'])===false 
				|| ( $this->getData(['config', 'cookieConsent'])===true && !isset( $_COOKIE['DELTA_COOKIE_CONSENT']))) { ?>
				<div class="row">
					<div class="col12 textAlignCenter">
						<?php echo template::captcha('formCaptcha', ''); ?>
					</div>
				</div>
				<?php } else { ?>
				<div class="row formCheckBlue">
					<?php echo template::text('formInputBlue', [
						'label' => 'Input Blue',
						'value' => ''
					]); ?>			
				</div>
				<br>
				<div class="row formOuter">
						<div class="formInner humanCheck">
							<?php echo template::checkbox('formHumanCheck', true, $this->getData(['locale', 'captchaSimpleText']), [
								'checked' => false,
								'help' => $this->getData(['locale', 'captchaSimpleHelp'])
							]); ?>
						</div>
				</div>
				<br>
				<?php } 
			}?>
			<div class="row textAlignCenter">
				<div class="formInner humanBotClose">
					<?php echo template::submit('formSubmit', [
						'value' => $this->getData(['module', $this->getUrl(0),'texts', 'send']),
						'ico' => ''
					]); ?>
				</div>
			</div>
		<?php echo template::formClose(); ?>
	<?php else: ?>
		<?php $textNoFields = $this->getData(['module', $this->getUrl(0),'texts', 'noFields']) ? $this->getData(['module', $this->getUrl(0),'texts', 'noFields']) : $text['form_view']['index'][1];
		echo template::speech( $textNoFields ); ?>
	<?php endif;
}	

// Affichage des statistiques ?>
<div class="result_wrapper">
<?php if( null !== $this->getData(['data_module', $this->getUrl(0), 'data' ]) && null !== $this->getData(['module', $this->getUrl(0), 'input' ])
	&& $this->getUser('group') >= $this->getData(['module', $this->getUrl(0), 'config', 'groupStat']) ){
?>
<h3><?php echo $this->getData(['module', $this->getUrl(0),'texts', 'results']); ?></h3>
	<div class="row">
			<div class="col12">
					<div class="block">
							<?php
							$dataval = $this->getData(['data_module', $this->getUrl(0), 'data' ]);
							// Suppression des participations non validées
							foreach( $dataval as $id=>$value){
							  if( isset($value['validation']['done']) && $value['validation']['done'] === false){
								unset( $dataval[$id]);
							  }
							}
							?><div class="blockTitle">
									 <?php $nbParti = count($dataval ); ?>
									<p><?php echo $this->getData(['module', $this->getUrl(0),'texts', 'numberResponses']) .' '. $nbParti; ?> </p>
							</div>
							<?php if($nbParti !== 0){
								$decimal_separator = $lang_page === 'fr_FR' ? ',':'.';
								$bigspace = '&nbsp;&nbsp;';
								$rightarrow = '&nbsp;&rarr;&nbsp;';
								// Pour chaque élément du formualire on recherche les types à associer aux statistiques
								foreach( $this->getData(['module', $this->getUrl(0), 'input' ]) as $numInput => $tabValue ){
									if( $tabValue['type'] === 'checkbox'){
										echo $tabValue['name'].'<br>';
										$nbCoche = 0;
										foreach($dataval as $numData => $tabData ){
											if( isset($tabData[$tabValue['id']]) && $tabData[$tabValue['id']] === "1") $nbCoche++;
										}
										$nbcheckpercent = round(100*($nbCoche / $nbParti),1);
										$nbnocheckpercent = 100 - $nbcheckpercent;
										echo '<ul class="checkbox"><li>'. $this->getData(['module', $this->getUrl(0),'texts', 'checked']) . $bigspace.$nbCoche . $rightarrow . number_format($nbcheckpercent,1,$decimal_separator,'') .'%</li>
											<li>'. $this->getData(['module', $this->getUrl(0),'texts', 'noChecked']) .$bigspace. ($nbParti - $nbCoche).$rightarrow . number_format($nbnocheckpercent,1,$decimal_separator,'') .'%</li></ul><br>';
				
									}
									if( $tabValue['type'] === 'select'){
										echo $tabValue['name'].'<br>';
										// Création du tableau avec pour clefs les items du select, pour valeur le nombre de fois qu'ils sont choisis
										$selectValues = [];
										$list = explode(',' , $tabValue['values']);
										foreach( $list as $key => $val){
											$selectValues[$val] = 0;
										}
										foreach($dataval as $numData => $tabData ){
											foreach( $list as $key => $val){
												if( isset( $tabData[$tabValue['id']] ) && $tabData[$tabValue['id']] === $val) $selectValues[$val]++;
											}									
										}
										echo '<ul class="select">';
										foreach( $list as $key => $val){
											echo '<li>'. $val .' : '. $bigspace . $selectValues[$val] . $rightarrow . number_format(100*($selectValues[$val] / $nbParti),1,$decimal_separator,'') .'%</li>';
										}	
										echo '</ul><br>';
									}
									if( $tabValue['type'] === 'selectMultiple'){
										echo $tabValue['name'].'<br>';
										// Création du tableau avec pour clefs les items du select, pour valeur le nombre de fois qu'ils sont choisis
										$selectValues = [];
										$list = explode(',' , $tabValue['values']);
										foreach( $list as $key => $val){
											$selectValues[$val] = 0;
										}
										foreach($dataval as $numData => $tabData ){
											foreach( $list as $key => $val){
												if( $val !== ""){
													if( isset($tabData[$tabValue['id']]) && strpos( $tabData[$tabValue['id']] , $val) !== false ) $selectValues[$val]++;
												}
											}									
										}
										echo '<ul class="selectMul">';
										foreach( $list as $key => $val){
											echo '<li>'. $val .' : '. $bigspace . $selectValues[$val] . $rightarrow . number_format(100*($selectValues[$val] / $nbParti),1,$decimal_separator,'') .'%</li>';
										}	
										echo '</ul><br>';
									}
									if( $tabValue['type'] === 'textarea'){
										echo $tabValue['name'].'<br>';
										// trouver le code clef de la question $keydata
										$keydata = $tabValue['id'];
										echo '<ul class="select">';
										// parcourir les data
										foreach($dataval as $numData => $tabData ){
											if( isset($tabData[ $keydata]) && $tabData[ $keydata] !== '') echo '<li>'. $tabData[ $keydata] .'</li>';
										}	
										echo '</ul><br>';									
										
									}
								}
							} ?>
							<p></p>
					</div>
			</div>
	</div>
	<?php } ?>
</div>
