<?php

/**
 * This file is part of DeltaCMS.
 * For full copyright and license information, please see the LICENSE
 * file that was distributed with this source code.
 * @author Sylvain Lelièvre <lelievresylvain@free.fr>
 * @copyright Copyright (C) 2021, Sylvain Lelièvre
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 *
 * Delta was created from version 11.2.00.24 of ZwiiCMS
 * @author Rémi Jean <remi.jean@outlook.com>
 * @copyright Copyright (C) 2008-2018, Rémi Jean
 * @author Frédéric Tempez <frederic.tempez@outlook.com>
 * @copyright Copyright (C) 2018-2021, Frédéric Tempez
 */
 
 

class templateswitch extends common {

	public static $actions = [
		'index' => self::GROUP_VISITOR,
		'config' => self::GROUP_MODERATOR
	];
	
	// N° de version
	const VERSION ='1.2';
	const REALNAME = 'Template Switch';
	const DELETE = true;
	const UPDATE = '0.0';
	const DATADIRECTORY = '';
	
	// variables
	public static $list=[];
	
	/**
	 * Mise à jour du module
	 * Appelée par les fonctions index et config
	*/
	private function update() {
		// Lexique
		include('./module/templateswitch/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_templateswitch.php');
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
			$this->init();
		} else {
			// Version 1.2
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '1.2', '<') ) {
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData','1.2']);
			}
		}
	}

	/**
	 * Initialisation
	*/
	private function init() {
		// Lexique
		include('./module/templateswitch/lang/'. helper::lexlang($this->getData(['config', 'i18n', 'langBase']) , $this->getData(['config', 'i18n', 'langAdmin'])) . '/lex_templateswitch.php');
		$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
		$this->setData(['module', $this->getUrl(0), 'currentTheme', '']);
		$this->setData(['module', $this->getUrl(0), 'currentDir', 'theme']);
		$this->setData(['module', $this->getUrl(0), 'textChangeFrontEnd', $text['templateswitch_view']['index'][0]]);
	}
	
	/**
	* fonction config()
	*/
	public function config() {
		// Autorisation : cette fonction sensible ne s'exécute que si le groupe de l'utilisateur y est autorisé
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < templateswitch::$actions['config'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);	
		} else {
			// Lexique
			include('./module/templateswitch/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_templateswitch.php');
			
			if($this->isPost()) {
				$dir =  $this->getInput('templateswitchConfigCurrentDir', helper::FILTER_STRING_SHORT, true);
				// Le dossier existe et il contient au moins un fichier zip
				if( is_dir( self::FILE_DIR.'source/'. $dir) && count(glob( self::FILE_DIR.'source/' . $dir .'/*.zip')) > 0 ){
					$this->setData(['module', $this->getUrl(0), 'currentDir', $dir ]);
					// Textes front end
					$this->setData(['module', $this->getUrl(0), 'textChangeFrontEnd', $this->getInput('templateswitchConfigTextChangeFrontEnd',helper::FILTER_STRING_SHORT)]);
							
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(),
						'notification' => $text['templateswitch']['config'][0],
						'state' => true
					]);
				} else {
					$this->addOutput([
						'redirect' => helper::baseUrl() . $this->getUrl(),
						'notification' => $text['templateswitch']['config'][2],
						'state' => false
					]);
				}
			}
			$this->addOutput([
				'title' => $text['templateswitch']['config'][1],
				'view' => 'config'
			]);
		}
	}
	
	/**
	* 
	*/
	public function index() {
		// Mise à jour des données de module
		if ( null===$this->getData(['module', $this->getUrl(0), 'config', 'versionData']) || version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<') ) $this->update();
		
		// Lexique
		include('./module/templateswitch/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_templateswitch.php');

		if($this->isPost()) {
			$zipFilename =	$this->getInput('templateswitchIndexImport', helper::FILTER_STRING_SHORT, true);
			$data = $this->import(self::FILE_DIR.'source/' . $zipFilename);
			if ($data['success']) {
				$this->setData(['module', $this->getUrl(0), 'currentTheme', $zipFilename ]);
				$this->addOutput([
					'redirect' => helper::baseUrl().$this->getUrl(),
				]);
			} else {
				// Valeurs en sortie
				$this->addOutput([
					'notification' => $data['notification'],
					'state' => $data['success'],
				]);;
			}
		}
		// Liste des zip thème
		$dirTheme = $this->getData(['module', $this->getUrl(0), 'currentDir' ]) . '/'; 
		$listUrl = glob( self::FILE_DIR.'source/' . $dirTheme .'*.zip');
		foreach ($listUrl as $file) {
			self::$list = array_merge( self::$list, array( $dirTheme . basename($file) => $dirTheme . basename($file)));
		}
		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index'
		]);
		
	}	
	
	/**
	 * Importe un thème
	 * @param string Url du thème à télécharger
	 * @param @return array contenant $success = true ou false ; $ notification string message à afficher
	 */

	private function import($zipName = '') {
		// Lexique
		include('./core/module/theme/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_theme.php');

		if ($zipName !== '' &&
			file_exists($zipName)) {
			// Init variables de retour
			$success = false;
			$notification = '';
			// Dossier temporaire
			$tempFolder = uniqid();
			// Ouvrir le zip
			$zip = new ZipArchive();
			if ($zip->open($zipName) === TRUE) {
				mkdir (self::TEMP_DIR . $tempFolder, 0755);
				$zip->extractTo(self::TEMP_DIR . $tempFolder );
				// Archive de thème front end ?
				if (file_exists(self::TEMP_DIR . $tempFolder . '/site/data/custom.css')
					AND file_exists(self::TEMP_DIR . $tempFolder . '/site/data/theme.css')
					AND file_exists(self::TEMP_DIR . $tempFolder . '/site/data/theme.json')
					) {
					// traiter l'archive
					$importFolder = './site/file/import';
					mkdir ($importFolder, 0755);
					$success = $zip->extractTo($importFolder);
					// $path = $importFolder.'/site/file/source/';
					$this->copyDir( $importFolder, './');
					$this->removeDir($importFolder);
					// traitement de l'erreur
					$notification = $success ? $text['core_theme']['import'][0] : $text['core_theme']['import'][1];
				} else {
					// pas une archive de thème front end
					$success = false;
					$notification = $text['core_theme']['import'][2];
				}
				// Supprimer le dossier temporaire même si le thème est invalide
				$this->removeDir(self::TEMP_DIR . $tempFolder);
				$zip->close();
			} else {
				// erreur à l'ouverture
				$success = false;
				$notification = $text['core_theme']['import'][3];
			}
			return (['success' => $success, 'notification' => $notification]);
		}
		return (['success' => false, 'notification' => $text['core_theme']['import'][4]]);
	}
}
