<?php
/**
 * Vidéo
 * @license GNU General Public License, version 3
 * @link https://deltacms.fr/
 * @copyright 2024 © Lionel Croquefer
 */
class video extends common {
	public static $actions = [
		'index' => self::GROUP_VISITOR,
		'config' => self::GROUP_EDITOR,
		'sortVideos' => self::GROUP_EDITOR
	];
	public static $listDirs = [];
	public static $videos = [];
	public static $videosId = [];

	const VERSION ='1.9';
	const REALNAME = 'Vidéo';
	const DELETE = true;
	const UPDATE = '0.0';
	const DATADIRECTORY = '';
	const SORT_ASC = 'SORT_ASC';
	const SORT_DSC = 'SORT_DSC';
	const SORT_HAND = 'SORT_HAND';

	// Mise à jour de la version du module
	private function update() {
		if (null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ) {
				$this->init();
			}
		else {
			// Version 1.5
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), '1.5', '<') ) {
				$style_index = 'module/video/view/index/index.css';
				if (file_exists($style_index)) {
				unlink($style_index);
				}
			}
			if (version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<')) {
				$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
			}
		}
	}

	// Initialisation
	private function init() {
		$this->setData(['module', $this->getUrl(0), 'config', 'versionData', self::VERSION]);
	}

	// Fonction de tri des videos dans config
	public function sortVideos() {
		// Autorisation
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if( $group < video::$actions['sortVideos'] ) {
			// Valeurs en sortie
			$this->addOutput([
				'access' => false
			]);
		} else {
		if($_POST['response']) {
			$data = explode('&',$_POST['response']);
			$data = str_replace('videoTable%5B%5D=','',$data);
			// Sauvegarder
			$this->setData(['module', $this->getUrl(0), [
			'config' => [
				'directory' => $this->getData(['module',$this->getUrl(0),'config','directory']),
				'spaceX' => $this->getData(['module',$this->getUrl(0),'config','spaceX']),
				'spaceY' => $this->getData(['module',$this->getUrl(0),'config','spaceY']),
				'sort' => $this->getData(['module',$this->getUrl(0),'config','sort'])
			],
			'legend' => $this->getData(['module',$this->getUrl(0),'legend']),
			'order' => array_flip($data)
			]]);
			}
		}
	}

	// Paramétrage du module,
	public function config() {
		// Autorisation
		$group = $this->getUser('group');
		if ($group === false ) $group = 0;
		if ($group < video::$actions['config']) {
			// Valeurs en sortie
			$this->addOutput(['access' => false]);
		} else {
		// Lexique
		$param = '';
		include('./module/video/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_video.php');

		// Liste les dossiers contenant des vidéos
		$filter = ['mp4','m4v','webm'];
			self::$listDirs = helper::scanDir(self::FILE_DIR.'source', $filter);
			sort(self::$listDirs);

		// Formulaire posté
		if($this->isPost()) {
			$legends = [];
			foreach((array) $this->getInput('legend', null) as $file => $legend) {
				$file = str_replace('.','',$file);
				$legends[$file] = helper::filter($legend, helper::FILTER_STRING_SHORT);
			}
			// Enregistrement dans module.json
			$this->setData(['module', $this->getUrl(0), [
				'config' => [
				'directory' => self::$listDirs[$this->getInput('videoConfigDirectory')],
				'spaceX' => $this->getInput('configVideoSpaceX'),
				'spaceY' => $this->getInput('configVideoSpaceY'),
				'sort' =>  $this->getInput('videoConfigSort'),
				'versionData' => self::VERSION
				],
				'legend' => $legends,
				'order' => $this->getData(['module', $this->getUrl(0), 'order'])
				]]);

			// Message et redirection après enregistrement de la configuration
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0),
				'notification' => $text['video']['config'][0],
				'state' => true
				]);
			}

			// Préparation du tableau
			$directory = $this->getData(['module', $this->getUrl(0), 'config', 'directory']) ?? '_none_';
			if (is_dir($directory)) {
			$resultats = videoHelper::recherche($directory);
			foreach ($resultats as $fileFound) {
				if (videoHelper::autorise($fileFound)) {
					$miniposter = file_exists(str_replace(strrchr(basename($fileFound), '.'), '.jpg', $fileFound)) ? str_replace(strrchr(basename($fileFound), '.'), '.jpg', $fileFound) : 'module/video/ressource/img/defaut.png';
					self::$videos[str_replace('.','',basename($fileFound))] = [
						template::ico('sort'),
						basename($fileFound),
						template::text('legend[' . basename($fileFound) . ']', [
							'value' => $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))])
						]),
						'<a href="'.$fileFound.'" rel="data-lity"><img class="config" src="'.$miniposter.'" alt="preview"></a>'
					];
					self::$videosId[] = str_replace('.','',basename($fileFound));
				}
			}
			// Tri des videos dans le tableau config
			$order = $this->getData(['module',$this->getUrl(0),'order']);
			switch ($this->getData(['module', $this->getUrl(0), 'config', 'sort'])) {
				case self::SORT_HAND:
					if ($order) {
						foreach ($order as $key => $value) {
							if (array_key_exists($key,self::$videos)) {
								$tempvideos[$key] = self::$videos[$key];
								$tempvideosId[] = $key;
							}
						}
						//Videos ayant été ajoutées dans le dossier mais non triées
						foreach (self::$videos as $key => $value) {
							if (!array_key_exists($key,$tempvideos)) {
								$tempvideos[$key] = self::$videos[$key];
								$tempvideosId[] = $key;
							}
						}
						self::$videos = $tempvideos;
						self::$videosId  = $tempvideosId;
					}
					break;
				case self::SORT_ASC:
					ksort(self::$videos,SORT_NATURAL | SORT_FLAG_CASE);
					sort(self::$videosId,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				case self::SORT_DSC:
					krsort(self::$videos,SORT_NATURAL | SORT_FLAG_CASE);
					rsort(self::$videosId,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				}
			}

			// ALLER à la configuration du module
			$this->addOutput([
				'title' => $text['video']['config'][1],
				'view' => 'config',
				'vendor' => ['tablednd']
			]);
		}
	}

	public function index() {
		if( null === $this->getData(['module', $this->getUrl(0), 'config', 'versionData']) ||  version_compare($this->getData(['module', $this->getUrl(0), 'config', 'versionData']), self::VERSION, '<') ) $this->update();
		// Lexique
		$param = '';
		include('./module/video/lang/'. $this->getData(['config', 'i18n', 'langAdmin']) . '/lex_video.php');

		// Module non configuré ?
		if (null === $this->getData(['module', $this->getUrl(0), 'config', 'directory' ])) {
			// ALLER à la configuration du module
			$this->addOutput([
				'redirect' => helper::baseUrl() . $this->getUrl(0).'/config',
				'notification' => $text['video']['index'][0],
				'state' => true
			]);
		}

		$directory = $this->getData(['module', $this->getUrl(0), 'config', 'directory']) ?? '_none_';
			if (is_dir($directory)) {
			$resultats = videoHelper::recherche($directory);
			foreach ($resultats as $fileFound) {
				if (videoHelper::autorise($fileFound)) {
						self::$videos[basename($fileFound)] = $this->getData(['module', $this->getUrl(0), 'legend', str_replace('.','',basename($fileFound))]);
						$videosSort[basename($fileFound)] = $this->getData(['module', $this->getUrl(0), 'order', str_replace('.','',basename($fileFound))]);
				}
			}
			// Tri des vidéos dans l'index
			switch ($this->getData(['module', $this->getUrl(0), 'config', 'sort'])) {
				case self::SORT_HAND:
					asort($videosSort);
					if ($videosSort) {
						foreach ($videosSort as $name => $position) {
							$temp[$name] = self::$videos[$name];
						}
						self::$videos = $temp;
					break;
					}
				case self::SORT_DSC:
					krsort(self::$videos,SORT_NATURAL | SORT_FLAG_CASE);
					break;
				case self::SORT_ASC:
				default:
					ksort(self::$videos,SORT_NATURAL | SORT_FLAG_CASE);
					break;
			}
		}

		// Valeurs en sortie
		$this->addOutput([
			'showBarEditButton' => true,
			'showPageContent' => true,
			'view' => 'index'
		]);
	}
}//video extends common

class videoHelper extends helper {
// Réécriture des noms
public static function separe($nom) {
	$separateurs = ['-','_','.'];
    return str_replace($separateurs, ' ', $nom);
}
// Limite de caractères
public static function smaller($nomcourt) {
	$shorten = helper::subword($nomcourt, 0, 40);
	if (strlen($shorten) < strlen($nomcourt)) $nomcourt = $shorten.'...';
	return $nomcourt;
}
// Recherche de vidéos
public static function recherche($dossier) {
	$recherche = glob($dossier.'/*.{mp4,m4v,webm,MP4,M4V,WEBM}', GLOB_BRACE);
	natcasesort($recherche);
	return $recherche;
}
// Filtrage par type mime
public static function autorise($fichier) {
	$allowed_types = ['mp4','x-m4v','webm'];
	$video_type = substr(strrchr(mime_content_type($fichier), '/'),1);
	return in_array($video_type, $allowed_types);
}
// class
}
